/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.hadoop.hbase.rest.NamespacesInstanceResource;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.model.NamespacesModel;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.PathParam;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Response;
import org.apache.hbase.thirdparty.javax.ws.rs.core.UriInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NamespacesResource
extends ResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(NamespacesResource.class);

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context ServletContext context, @Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            NamespacesModel rowModel = null;
            rowModel = new NamespacesModel(this.servlet.getAdmin());
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return Response.ok((Object)rowModel).build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            throw new RuntimeException("Cannot retrieve list of namespaces.");
        }
    }

    @Path(value="{namespace}")
    public NamespacesInstanceResource getNamespaceInstanceResource(@PathParam(value="namespace") String namespace) throws IOException {
        return new NamespacesInstanceResource(namespace);
    }
}

