/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RestUtil {
    private RestUtil() {
    }

    public static RowModel createRowModelFromResult(Result r) {
        Cell firstCell = r.rawCells()[0];
        RowModel rowModel = new RowModel(firstCell.getRowArray(), firstCell.getRowOffset(), firstCell.getRowLength());
        int cellsLength = r.rawCells().length;
        for (int i = 0; i < cellsLength; ++i) {
            rowModel.addCell(new CellModel(r.rawCells()[i]));
        }
        return rowModel;
    }

    public static void mergeFrom(Message.Builder builder, CodedInputStream codedInput) throws IOException {
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }
}

