/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class BloomContext {
    protected BloomFilterWriter bloomFilterWriter;
    protected CellComparator comparator;

    public BloomContext(BloomFilterWriter bloomFilterWriter, CellComparator comparator) {
        this.bloomFilterWriter = bloomFilterWriter;
        this.comparator = comparator;
    }

    public Cell getLastCell() {
        return this.bloomFilterWriter.getPrevCell();
    }

    public void writeBloom(Cell cell) throws IOException {
        if (this.isNewKey(cell)) {
            this.sanityCheck(cell);
            this.bloomFilterWriter.append(cell);
        }
    }

    private void sanityCheck(Cell cell) throws IOException {
        if (this.getLastCell() != null && this.comparator.compare(cell, this.getLastCell()) <= 0) {
            throw new IOException("Added a key not lexically larger than previous. Current cell = " + cell + ", prevCell = " + this.getLastCell());
        }
    }

    public abstract void addLastBloomKey(HFile.Writer var1) throws IOException;

    protected abstract boolean isNewKey(Cell var1);
}

