/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ConnectionRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.OpenTelemetryClassRule;
import org.apache.hadoop.hbase.trace.OpenTelemetryTestRule;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

public abstract class AbstractTestAsyncTableScan {
    protected static final OpenTelemetryClassRule OTEL_CLASS_RULE = OpenTelemetryClassRule.create();
    protected static final MiniClusterRule MINI_CLUSTER_RULE = MiniClusterRule.newBuilder().setMiniClusterOption(StartMiniClusterOption.builder().numWorkers(3).build()).build();
    protected static final ConnectionRule CONN_RULE = ConnectionRule.createAsyncConnectionRule(MINI_CLUSTER_RULE::createAsyncConnection);
    @ClassRule
    public static final TestRule classRule = RuleChain.outerRule((TestRule)OTEL_CLASS_RULE).around((TestRule)MINI_CLUSTER_RULE).around((TestRule)CONN_RULE).around((TestRule)new Setup());
    @Rule
    public final OpenTelemetryTestRule otelTestRule = new OpenTelemetryTestRule(OTEL_CLASS_RULE);
    @Rule
    public final TestName testName = new TestName();
    protected static TableName TABLE_NAME = TableName.valueOf((String)"async");
    protected static byte[] FAMILY = Bytes.toBytes((String)"cf");
    protected static byte[] CQ1 = Bytes.toBytes((String)"cq1");
    protected static byte[] CQ2 = Bytes.toBytes((String)"cq2");
    protected static int COUNT = 1000;

    private static Scan createNormalScan() {
        return new Scan();
    }

    private static Scan createBatchScan() {
        return new Scan().setBatch(1);
    }

    private static Scan createSmallResultSizeScan() {
        return new Scan().setMaxResultSize(1L);
    }

    private static Scan createBatchSmallResultSizeScan() {
        return new Scan().setBatch(1).setMaxResultSize(1L);
    }

    private static AsyncTable<?> getRawTable() {
        return CONN_RULE.getAsyncConnection().getTable(TABLE_NAME);
    }

    private static AsyncTable<?> getTable() {
        return CONN_RULE.getAsyncConnection().getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool());
    }

    private static List<Pair<String, Supplier<Scan>>> getScanCreator() {
        return Arrays.asList(Pair.newPair((Object)"normal", AbstractTestAsyncTableScan::createNormalScan), Pair.newPair((Object)"batch", AbstractTestAsyncTableScan::createBatchScan), Pair.newPair((Object)"smallResultSize", AbstractTestAsyncTableScan::createSmallResultSizeScan), Pair.newPair((Object)"batchSmallResultSize", AbstractTestAsyncTableScan::createBatchSmallResultSizeScan));
    }

    /*
     * Exception decompiling
     */
    protected static List<Object[]> getScanCreatorParams() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<Pair<String, Supplier<AsyncTable<?>>>> getTableCreator() {
        return Arrays.asList(Pair.newPair((Object)"raw", AbstractTestAsyncTableScan::getRawTable), Pair.newPair((Object)"normal", AbstractTestAsyncTableScan::getTable));
    }

    protected static List<Object[]> getTableAndScanCreatorParams() {
        List<Pair<String, Supplier<AsyncTable<?>>>> tableCreator = AbstractTestAsyncTableScan.getTableCreator();
        List<Pair<String, Supplier<Scan>>> scanCreator = AbstractTestAsyncTableScan.getScanCreator();
        return tableCreator.stream().flatMap(tp -> scanCreator.stream().map(sp -> new Object[]{tp.getFirst(), tp.getSecond(), sp.getFirst(), sp.getSecond()})).collect(Collectors.toList());
    }

    protected abstract Scan createScan();

    protected abstract List<Result> doScan(Scan var1, int var2) throws Exception;

    protected abstract void assertTraceContinuity();

    protected abstract void assertTraceError(Matcher<Attributes> var1);

    protected final List<Result> convertFromBatchResult(List<Result> results) {
        Assert.assertEquals((long)0L, (long)(results.size() % 2));
        return IntStream.range(0, results.size() / 2).mapToObj(i -> {
            try {
                return Result.createCompleteResult(Arrays.asList((Result)results.get(2 * i), (Result)results.get(2 * i + 1)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
    }

    protected static void waitForSpan(Matcher<SpanData> parentSpanMatcher) {
        Configuration conf = MINI_CLUSTER_RULE.getTestingUtility().getConfiguration();
        Waiter.waitFor((Configuration)conf, (long)TimeUnit.SECONDS.toMillis(5L), (Waiter.Predicate)new MatcherPredicate("Span for test failed to complete.", OTEL_CLASS_RULE::getSpans, Matchers.hasItem(parentSpanMatcher)));
    }

    protected static Stream<SpanData> spanStream() {
        return OTEL_CLASS_RULE.getSpans().stream().filter(Objects::nonNull);
    }

    @Test
    public void testScanAll() throws Exception {
        List<Result> results = this.doScan(this.createScan(), -1);
        MINI_CLUSTER_RULE.getTestingUtility().getHBaseCluster().getRegionServerThreads().stream().map(JVMClusterUtil.RegionServerThread::getRegionServer).forEach(rs -> Assert.assertEquals((String)("The scanner count of " + rs.getServerName() + " is " + rs.getRSRpcServices().getScannersCount()), (long)0L, (long)rs.getRSRpcServices().getScannersCount()));
        Assert.assertEquals((long)COUNT, (long)results.size());
        IntStream.range(0, COUNT).forEach(i -> {
            Result result = (Result)results.get(i);
            Assert.assertEquals((Object)String.format("%03d", i), (Object)Bytes.toString((byte[])result.getRow()));
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQ1)));
        });
    }

    private void assertResultEquals(Result result, int i) {
        Assert.assertEquals((Object)String.format("%03d", i), (Object)Bytes.toString((byte[])result.getRow()));
        Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQ1)));
        Assert.assertEquals((long)(i * i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQ2)));
    }

    @Test
    public void testReversedScanAll() throws Exception {
        List results = (List)TraceUtil.trace(() -> this.doScan(this.createScan().setReversed(true), -1), (String)this.testName.getMethodName());
        Assert.assertEquals((long)COUNT, (long)results.size());
        IntStream.range(0, COUNT).forEach(i -> this.assertResultEquals((Result)results.get(i), COUNT - i - 1));
        this.assertTraceContinuity();
    }

    @Test
    public void testScanNoStopKey() throws Exception {
        int start = 345;
        List results = (List)TraceUtil.trace(() -> this.doScan(this.createScan().withStartRow(Bytes.toBytes((String)String.format("%03d", start))), -1), (String)this.testName.getMethodName());
        Assert.assertEquals((long)(COUNT - start), (long)results.size());
        IntStream.range(0, COUNT - start).forEach(i -> this.assertResultEquals((Result)results.get(i), start + i));
        this.assertTraceContinuity();
    }

    @Test
    public void testReverseScanNoStopKey() throws Exception {
        int start = 765;
        Scan scan = this.createScan().withStartRow(Bytes.toBytes((String)String.format("%03d", start))).setReversed(true);
        List results = (List)TraceUtil.trace(() -> this.doScan(scan, -1), (String)this.testName.getMethodName());
        Assert.assertEquals((long)(start + 1), (long)results.size());
        IntStream.range(0, start + 1).forEach(i -> this.assertResultEquals((Result)results.get(i), start - i));
        this.assertTraceContinuity();
    }

    @Test
    public void testScanWrongColumnFamily() {
        Exception e = (Exception)Assert.assertThrows(Exception.class, () -> {
            List cfr_ignored_0 = (List)TraceUtil.trace(() -> this.doScan(this.createScan().addFamily(Bytes.toBytes((String)"WrongColumnFamily")), -1), (String)this.testName.getMethodName());
        });
        if (e instanceof NoSuchColumnFamilyException) {
            NoSuchColumnFamilyException ex = (NoSuchColumnFamilyException)e;
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.isA(NoSuchColumnFamilyException.class));
        } else if (e instanceof ExecutionException) {
            ExecutionException ex = (ExecutionException)e;
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.allOf((Matcher)Matchers.isA(ExecutionException.class), (Matcher)Matchers.hasProperty((String)"cause", (Matcher)Matchers.isA(NoSuchColumnFamilyException.class))));
        } else {
            Assert.fail((String)("Found unexpected Exception " + e));
        }
        this.assertTraceError((Matcher<Attributes>)Matchers.anyOf((Matcher)AttributesMatchers.containsEntry((Matcher)Matchers.is((Object)HBaseSemanticAttributes.EXCEPTION_TYPE), (Matcher)Matchers.endsWith((String)NoSuchColumnFamilyException.class.getName())), (Matcher)Matchers.allOf((Matcher)AttributesMatchers.containsEntry((Matcher)Matchers.is((Object)HBaseSemanticAttributes.EXCEPTION_TYPE), (Matcher)Matchers.endsWith((String)RemoteWithExtrasException.class.getName())), (Matcher)AttributesMatchers.containsEntry((Matcher)Matchers.is((Object)HBaseSemanticAttributes.EXCEPTION_MESSAGE), (Matcher)Matchers.containsString((String)NoSuchColumnFamilyException.class.getName())))));
    }

    private void testScan(int start, boolean startInclusive, int stop, boolean stopInclusive, int limit) throws Exception {
        this.testScan(start, startInclusive, stop, stopInclusive, limit, -1);
    }

    private void testScan(int start, boolean startInclusive, int stop, boolean stopInclusive, int limit, int closeAfter) throws Exception {
        Scan scan = this.createScan().withStartRow(Bytes.toBytes((String)String.format("%03d", start)), startInclusive).withStopRow(Bytes.toBytes((String)String.format("%03d", stop)), stopInclusive);
        if (limit > 0) {
            scan.setLimit(limit);
        }
        List<Result> results = this.doScan(scan, closeAfter);
        int actualStart = startInclusive ? start : start + 1;
        int actualStop = stopInclusive ? stop + 1 : stop;
        int count = actualStop - actualStart;
        if (limit > 0) {
            count = Math.min(count, limit);
        }
        if (closeAfter > 0) {
            count = Math.min(count, closeAfter);
        }
        Assert.assertEquals((long)count, (long)results.size());
        IntStream.range(0, count).forEach(i -> this.assertResultEquals((Result)results.get(i), actualStart + i));
    }

    private void testReversedScan(int start, boolean startInclusive, int stop, boolean stopInclusive, int limit) throws Exception {
        Scan scan = this.createScan().withStartRow(Bytes.toBytes((String)String.format("%03d", start)), startInclusive).withStopRow(Bytes.toBytes((String)String.format("%03d", stop)), stopInclusive).setReversed(true);
        if (limit > 0) {
            scan.setLimit(limit);
        }
        List<Result> results = this.doScan(scan, -1);
        int actualStart = startInclusive ? start : start - 1;
        int actualStop = stopInclusive ? stop - 1 : stop;
        int count = actualStart - actualStop;
        if (limit > 0) {
            count = Math.min(count, limit);
        }
        Assert.assertEquals((long)count, (long)results.size());
        IntStream.range(0, count).forEach(i -> this.assertResultEquals((Result)results.get(i), actualStart - i));
    }

    @Test
    public void testScanWithStartKeyAndStopKey() throws Exception {
        this.testScan(1, true, 998, false, -1);
        this.testScan(123, true, 345, true, -1);
        this.testScan(234, true, 456, false, -1);
        this.testScan(345, false, 567, true, -1);
        this.testScan(456, false, 678, false, -1);
    }

    @Test
    public void testReversedScanWithStartKeyAndStopKey() throws Exception {
        this.testReversedScan(998, true, 1, false, -1);
        this.testReversedScan(543, true, 321, true, -1);
        this.testReversedScan(654, true, 432, false, -1);
        this.testReversedScan(765, false, 543, true, -1);
        this.testReversedScan(876, false, 654, false, -1);
    }

    @Test
    public void testScanAtRegionBoundary() throws Exception {
        this.testScan(222, true, 333, true, -1);
        this.testScan(333, true, 444, false, -1);
        this.testScan(444, false, 555, true, -1);
        this.testScan(555, false, 666, false, -1);
    }

    @Test
    public void testReversedScanAtRegionBoundary() throws Exception {
        this.testReversedScan(333, true, 222, true, -1);
        this.testReversedScan(444, true, 333, false, -1);
        this.testReversedScan(555, false, 444, true, -1);
        this.testReversedScan(666, false, 555, false, -1);
    }

    @Test
    public void testScanWithLimit() throws Exception {
        this.testScan(1, true, 998, false, 900);
        this.testScan(123, true, 234, true, 100);
        this.testScan(234, true, 456, false, 100);
        this.testScan(345, false, 567, true, 100);
        this.testScan(456, false, 678, false, 100);
    }

    @Test
    public void testScanWithLimitGreaterThanActualCount() throws Exception {
        this.testScan(1, true, 998, false, 1000);
        this.testScan(123, true, 345, true, 200);
        this.testScan(234, true, 456, false, 200);
        this.testScan(345, false, 567, true, 200);
        this.testScan(456, false, 678, false, 200);
    }

    @Test
    public void testReversedScanWithLimit() throws Exception {
        this.testReversedScan(998, true, 1, false, 900);
        this.testReversedScan(543, true, 321, true, 100);
        this.testReversedScan(654, true, 432, false, 100);
        this.testReversedScan(765, false, 543, true, 100);
        this.testReversedScan(876, false, 654, false, 100);
    }

    @Test
    public void testReversedScanWithLimitGreaterThanActualCount() throws Exception {
        this.testReversedScan(998, true, 1, false, 1000);
        this.testReversedScan(543, true, 321, true, 200);
        this.testReversedScan(654, true, 432, false, 200);
        this.testReversedScan(765, false, 543, true, 200);
        this.testReversedScan(876, false, 654, false, 200);
    }

    @Test
    public void testScanEndingEarly() throws Exception {
        this.testScan(1, true, 998, false, 0, 900);
        this.testScan(123, true, 234, true, 0, 100);
        this.testScan(234, true, 456, false, 0, 100);
        this.testScan(345, false, 567, true, 0, 100);
        this.testScan(456, false, 678, false, 0, 100);
    }

    private static final class Setup
    extends ExternalResource {
        private Setup() {
        }

        protected void before() throws Throwable {
            HBaseTestingUtility testingUtil = MINI_CLUSTER_RULE.getTestingUtility();
            AsyncConnection conn = CONN_RULE.getAsyncConnection();
            byte[][] splitKeys = new byte[8][];
            for (int i2 = 111; i2 < 999; i2 += 111) {
                splitKeys[i2 / 111 - 1] = Bytes.toBytes((String)String.format("%03d", i2));
            }
            testingUtil.createTable(TABLE_NAME, FAMILY, (byte[][])splitKeys);
            testingUtil.waitTableAvailable(TABLE_NAME);
            conn.getTable(TABLE_NAME).putAll(IntStream.range(0, COUNT).mapToObj(i -> new Put(Bytes.toBytes((String)String.format("%03d", i))).addColumn(FAMILY, CQ1, Bytes.toBytes((int)i)).addColumn(FAMILY, CQ2, Bytes.toBytes((int)(i * i)))).collect(Collectors.toList())).get();
        }
    }
}

