/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestDeleteTableProcedure
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDeleteTableProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestDeleteTableProcedure.class);
    @Rule
    public TestName name = new TestName();

    @Test(expected=TableNotFoundException.class)
    public void testDeleteNotExistentTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedurePrepareLatch.CompatibilityLatch latch = new ProcedurePrepareLatch.CompatibilityLatch();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, (ProcedurePrepareLatch)latch));
        latch.await();
    }

    @Test(expected=TableNotDisabledException.class)
    public void testDeleteNotDisabledTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        ProcedurePrepareLatch.CompatibilityLatch latch = new ProcedurePrepareLatch.CompatibilityLatch();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, (ProcedurePrepareLatch)latch));
        latch.await();
    }

    @Test
    public void testDeleteDeletedTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        UTIL.getAdmin().disableTable(tableName);
        long procId1 = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        long procId2 = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        MasterProcedureTestingUtility.validateTableDeletion(this.getMaster(), tableName);
        Procedure result = procExec.getResult(procId2);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug("Delete failed with exception: " + result.getException());
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof TableNotFoundException));
    }

    @Test
    public void testSimpleDelete() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = null;
        this.testSimpleDelete(tableName, splitKeys);
    }

    @Test
    public void testSimpleDeleteWithSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        this.testSimpleDelete(tableName, splitKeys);
    }

    @Test
    public void testDeleteFromMeta() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, null, "f1", "f2");
        ArrayList regionsList = new ArrayList();
        UTIL.getAdmin().disableTable(tableName);
        MasterProcedureEnv procedureEnv = (MasterProcedureEnv)this.getMasterProcedureExecutor().getEnvironment();
        Assert.assertNotNull((String)"Table should be on TableDescriptors cache.", (Object)procedureEnv.getMasterServices().getTableDescriptors().get(tableName));
        DeleteTableProcedure.deleteFromMeta((MasterProcedureEnv)procedureEnv, (TableName)tableName, regionsList);
        Assert.assertNull((String)"Table shouldn't be on TableDescriptors anymore.", (Object)procedureEnv.getMasterServices().getTableDescriptors().get(tableName));
    }

    private void testSimpleDelete(TableName tableName, byte[][] splitKeys) throws Exception {
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        MasterProcedureTestingUtility.validateTableDeletion(this.getMaster(), tableName);
    }

    @Test
    public void testRecoveryAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = null;
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        MasterProcedureTestingUtility.validateTableDeletion(this.getMaster(), tableName);
    }
}

