/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestLogRollingNoCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLogRollingNoCluster.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] EMPTY_1K_ARRAY = new byte[1024];
    private static final int NUM_THREADS = 100;
    private static final int NUM_ENTRIES = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContendedLogRolling() throws Exception {
        int i;
        TEST_UTIL.startMiniDFSCluster(3);
        Path dir = TEST_UTIL.getDataTestDirOnTestFS();
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.handler.count", 100);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.wal.provider", "filesystem");
        CommonFSUtils.setRootDir((Configuration)conf, (Path)dir);
        FSTableDescriptors fsTableDescriptors = new FSTableDescriptors(TEST_UTIL.getConfiguration());
        FSTableDescriptors.tryUpdateMetaTableDescriptor((Configuration)TEST_UTIL.getConfiguration());
        TableDescriptor metaTableDescriptor = fsTableDescriptors.get(TableName.META_TABLE_NAME);
        conf.set("hbase.regionserver.wal.writer.impl", HighLatencySyncWriter.class.getName());
        WALFactory wals = new WALFactory(conf, TestLogRollingNoCluster.class.getName());
        WAL wal = wals.getWAL(null);
        Appender[] appenders = null;
        int numThreads = 100;
        appenders = new Appender[100];
        try {
            for (i = 0; i < 100; ++i) {
                appenders[i] = new Appender(metaTableDescriptor, wal, i, 100);
            }
            for (i = 0; i < 100; ++i) {
                appenders[i].start();
            }
            for (i = 0; i < 100; ++i) {
                appenders[i].join();
            }
        }
        finally {
            wals.close();
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertFalse((String)("Error: " + appenders[i].getException()), (boolean)appenders[i].isException());
        }
        TEST_UTIL.shutdownMiniDFSCluster();
    }

    static class Appender
    extends Thread {
        private final Logger log;
        private final WAL wal;
        private final int count;
        private Exception e = null;
        private final TableDescriptor metaTableDescriptor;

        Appender(TableDescriptor metaTableDescriptor, WAL wal, int index, int count) {
            super("" + index);
            this.wal = wal;
            this.count = count;
            this.metaTableDescriptor = metaTableDescriptor;
            this.log = LoggerFactory.getLogger((String)("Appender:" + this.getName()));
        }

        boolean isException() {
            return !this.isAlive() && this.e != null;
        }

        Exception getException() {
            return this.e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.log.info(this.getName() + " started");
            MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
            try {
                FSTableDescriptors tds = new FSTableDescriptors(TEST_UTIL.getConfiguration());
                TableDescriptor htd = tds.get(TableName.META_TABLE_NAME);
                for (int i = 0; i < this.count; ++i) {
                    long now = EnvironmentEdgeManager.currentTime();
                    if (i % 10 == 0) {
                        this.wal.rollWriter();
                    }
                    WALEdit edit = new WALEdit();
                    byte[] bytes = Bytes.toBytes((int)i);
                    edit.add((Cell)new KeyValue(bytes, bytes, bytes, now, EMPTY_1K_ARRAY));
                    RegionInfo hri = RegionInfoBuilder.FIRST_META_REGIONINFO;
                    TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
                    for (byte[] fam : this.metaTableDescriptor.getColumnFamilyNames()) {
                        scopes.put(fam, 0);
                    }
                    long txid = this.wal.appendData(hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), TableName.META_TABLE_NAME, now, mvcc, scopes), edit);
                    Threads.sleep((long)ThreadLocalRandom.current().nextInt(5));
                    this.wal.sync(txid);
                }
                String msg = this.getName() + " finished";
                if (this.isException()) {
                    this.log.info(msg, (Throwable)this.getException());
                } else {
                    this.log.info(msg);
                }
            }
            catch (Exception e) {
                this.e = e;
                this.log.info("Caught exception from Appender:" + this.getName(), (Throwable)e);
            }
            finally {
                try {
                    this.wal.sync();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class HighLatencySyncWriter
    extends ProtobufLogWriter {
        public void sync(boolean forceSync) throws IOException {
            Threads.sleep((long)ThreadLocalRandom.current().nextInt(10));
            super.sync(forceSync);
            Threads.sleep((long)ThreadLocalRandom.current().nextInt(10));
        }
    }
}

