/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.replication.TestReplicationSyncUpToolBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationSyncUpTool
extends TestReplicationSyncUpToolBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSyncUpTool.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationSyncUpTool.class);

    @Test
    public void testSyncUpTool() throws Exception {
        this.setupReplication();
        this.putAndReplicateRows();
        this.mimicSyncUpAfterDelete();
        this.mimicSyncUpAfterPut();
    }

    private void putAndReplicateRows() throws Exception {
        Put p;
        int i;
        LOG.debug("putAndReplicateRows");
        for (i = 0; i < 100; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("val" + i)));
            this.ht1Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9999"));
        p.addColumn(NO_REP_FAMILY, QUALIFIER, Bytes.toBytes((String)"val9999"));
        this.ht1Source.put(p);
        for (i = 0; i < 200; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("val" + i)));
            this.ht2Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9999"));
        p.addColumn(NO_REP_FAMILY, QUALIFIER, Bytes.toBytes((String)"val9999"));
        this.ht2Source.put(p);
        Thread.sleep(500L);
        int rowCountHt1Source = UTIL1.countRows(this.ht1Source);
        for (int i2 = 0; i2 < 50; ++i2) {
            int rowCountHt1TargetAtPeer1 = UTIL2.countRows(this.ht1TargetAtPeer1);
            if (i2 == 49) {
                Assert.assertEquals((String)"t1_syncup has 101 rows on source, and 100 on slave1", (long)(rowCountHt1Source - 1), (long)rowCountHt1TargetAtPeer1);
            }
            if (rowCountHt1Source - 1 == rowCountHt1TargetAtPeer1) break;
            Thread.sleep(500L);
        }
        int rowCountHt2Source = UTIL1.countRows(this.ht2Source);
        for (int i3 = 0; i3 < 50; ++i3) {
            int rowCountHt2TargetAtPeer1 = UTIL2.countRows(this.ht2TargetAtPeer1);
            if (i3 == 49) {
                Assert.assertEquals((String)"t2_syncup has 201 rows on source, and 200 on slave1", (long)(rowCountHt2Source - 1), (long)rowCountHt2TargetAtPeer1);
            }
            if (rowCountHt2Source - 1 == rowCountHt2TargetAtPeer1) break;
            Thread.sleep(500L);
        }
    }

    private void mimicSyncUpAfterDelete() throws Exception {
        Delete del;
        String rowKey;
        int i;
        LOG.debug("mimicSyncUpAfterDelete");
        this.shutDownTargetHBaseCluster();
        ArrayList<Delete> list = new ArrayList<Delete>();
        for (i = 0; i < 50; ++i) {
            rowKey = "row" + i;
            del = new Delete(Bytes.toBytes((String)rowKey));
            list.add(del);
        }
        this.ht1Source.delete(list);
        for (i = 0; i < 100; ++i) {
            rowKey = "row" + i;
            del = new Delete(Bytes.toBytes((String)rowKey));
            list.add(del);
        }
        this.ht2Source.delete(list);
        int rowCount_ht1Source = UTIL1.countRows(this.ht1Source);
        Assert.assertEquals((String)"t1_syncup has 51 rows on source, after remove 50 of the replicated colfam", (long)51L, (long)rowCount_ht1Source);
        int rowCount_ht2Source = UTIL1.countRows(this.ht2Source);
        Assert.assertEquals((String)"t2_syncup has 101 rows on source, after remove 100 of the replicated colfam", (long)101L, (long)rowCount_ht2Source);
        this.shutDownSourceHBaseCluster();
        this.restartTargetHBaseCluster(1);
        Thread.sleep(500L);
        int rowCountHt1TargetAtPeer1 = UTIL2.countRows(this.ht1TargetAtPeer1);
        int rowCountHt2TargetAtPeer1 = UTIL2.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should still have 100 rows", (long)100L, (long)rowCountHt1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should still have 200 rows", (long)200L, (long)rowCountHt2TargetAtPeer1);
        for (int i2 = 0; i2 < 50; ++i2) {
            this.syncUp(UTIL1);
            rowCountHt1TargetAtPeer1 = UTIL2.countRows(this.ht1TargetAtPeer1);
            rowCountHt2TargetAtPeer1 = UTIL2.countRows(this.ht2TargetAtPeer1);
            if (i2 == 49) {
                if (rowCountHt1TargetAtPeer1 != 50 || rowCountHt2TargetAtPeer1 != 100) {
                    this.restartSourceHBaseCluster(1);
                    rowCount_ht1Source = UTIL1.countRows(this.ht1Source);
                    LOG.debug("t1_syncup should have 51 rows at source, and it is " + rowCount_ht1Source);
                    rowCount_ht2Source = UTIL1.countRows(this.ht2Source);
                    LOG.debug("t2_syncup should have 101 rows at source, and it is " + rowCount_ht2Source);
                }
                Assert.assertEquals((String)"@Peer1 t1_syncup should be sync up and have 50 rows", (long)50L, (long)rowCountHt1TargetAtPeer1);
                Assert.assertEquals((String)"@Peer1 t2_syncup should be sync up and have 100 rows", (long)100L, (long)rowCountHt2TargetAtPeer1);
            }
            if (rowCountHt1TargetAtPeer1 == 50 && rowCountHt2TargetAtPeer1 == 100) {
                LOG.info("SyncUpAfterDelete succeeded at retry = " + i2);
                break;
            }
            LOG.debug("SyncUpAfterDelete failed at retry = " + i2 + ", with rowCount_ht1TargetPeer1 =" + rowCountHt1TargetAtPeer1 + " and rowCount_ht2TargetAtPeer1 =" + rowCountHt2TargetAtPeer1);
            Thread.sleep(500L);
        }
    }

    private void mimicSyncUpAfterPut() throws Exception {
        Put p;
        int i;
        LOG.debug("mimicSyncUpAfterPut");
        this.restartSourceHBaseCluster(1);
        this.shutDownTargetHBaseCluster();
        for (i = 0; i < 100; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("val" + i)));
            this.ht1Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9998"));
        p.addColumn(NO_REP_FAMILY, QUALIFIER, Bytes.toBytes((String)"val9998"));
        this.ht1Source.put(p);
        for (i = 0; i < 200; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("val" + i)));
            this.ht2Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9998"));
        p.addColumn(NO_REP_FAMILY, QUALIFIER, Bytes.toBytes((String)"val9998"));
        this.ht2Source.put(p);
        int rowCount_ht1Source = UTIL1.countRows(this.ht1Source);
        Assert.assertEquals((String)"t1_syncup has 102 rows on source", (long)102L, (long)rowCount_ht1Source);
        int rowCount_ht2Source = UTIL1.countRows(this.ht2Source);
        Assert.assertEquals((String)"t2_syncup has 202 rows on source", (long)202L, (long)rowCount_ht2Source);
        this.shutDownSourceHBaseCluster();
        this.restartTargetHBaseCluster(1);
        Thread.sleep(500L);
        int rowCountHt1TargetAtPeer1 = UTIL2.countRows(this.ht1TargetAtPeer1);
        int rowCountHt2TargetAtPeer1 = UTIL2.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should be NOT sync up and have 50 rows", (long)50L, (long)rowCountHt1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should be NOT sync up and have 100 rows", (long)100L, (long)rowCountHt2TargetAtPeer1);
        for (int i2 = 0; i2 < 50; ++i2) {
            this.syncUp(UTIL1);
            rowCountHt1TargetAtPeer1 = UTIL2.countRows(this.ht1TargetAtPeer1);
            rowCountHt2TargetAtPeer1 = UTIL2.countRows(this.ht2TargetAtPeer1);
            if (i2 == 49) {
                if (rowCountHt1TargetAtPeer1 != 100 || rowCountHt2TargetAtPeer1 != 200) {
                    this.restartSourceHBaseCluster(1);
                    rowCount_ht1Source = UTIL1.countRows(this.ht1Source);
                    LOG.debug("t1_syncup should have 102 rows at source, and it is " + rowCount_ht1Source);
                    rowCount_ht2Source = UTIL1.countRows(this.ht2Source);
                    LOG.debug("t2_syncup should have 202 rows at source, and it is " + rowCount_ht2Source);
                }
                Assert.assertEquals((String)"@Peer1 t1_syncup should be sync up and have 100 rows", (long)100L, (long)rowCountHt1TargetAtPeer1);
                Assert.assertEquals((String)"@Peer1 t2_syncup should be sync up and have 200 rows", (long)200L, (long)rowCountHt2TargetAtPeer1);
            }
            if (rowCountHt1TargetAtPeer1 == 100 && rowCountHt2TargetAtPeer1 == 200) {
                LOG.info("SyncUpAfterPut succeeded at retry = " + i2);
                break;
            }
            LOG.debug("SyncUpAfterPut failed at retry = " + i2 + ", with rowCount_ht1TargetPeer1 =" + rowCountHt1TargetAtPeer1 + " and rowCount_ht2TargetAtPeer1 =" + rowCountHt2TargetAtPeer1);
            Thread.sleep(500L);
        }
    }
}

