/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import javax.security.sasl.SaslException;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.handler.codec.MessageToByteEncoder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SaslWrapHandler
extends MessageToByteEncoder<ByteBuf> {
    private final Wrapper wrapper;

    public SaslWrapHandler(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        byte[] bytes = new byte[msg.readableBytes()];
        msg.readBytes(bytes);
        byte[] wrapperBytes = this.wrapper.wrap(bytes, 0, bytes.length);
        out.ensureWritable(4 + wrapperBytes.length);
        out.writeInt(wrapperBytes.length);
        out.writeBytes(wrapperBytes);
    }

    public static interface Wrapper {
        public byte[] wrap(byte[] var1, int var2, int var3) throws SaslException;
    }
}

