/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.cairo.TableWriterMetrics;
import io.questdb.cairo.wal.WalMetrics;
import io.questdb.cutlass.http.processors.HttpMetrics;
import io.questdb.cutlass.http.processors.JsonQueryMetrics;
import io.questdb.cutlass.line.LineMetrics;
import io.questdb.cutlass.pgwire.PGMetrics;
import io.questdb.metrics.GCMetrics;
import io.questdb.metrics.HealthMetricsImpl;
import io.questdb.metrics.MetricsRegistry;
import io.questdb.metrics.MetricsRegistryImpl;
import io.questdb.metrics.NullMetricsRegistry;
import io.questdb.metrics.Target;
import io.questdb.metrics.VirtualLongGauge;
import io.questdb.metrics.WorkerMetrics;
import io.questdb.std.Mutable;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.BorrowableUtf8Sink;
import org.jetbrains.annotations.NotNull;

public class Metrics
implements Target,
Mutable {
    public static final Metrics DISABLED = new Metrics(false, new NullMetricsRegistry());
    public static final Metrics ENABLED = new Metrics(true, new MetricsRegistryImpl());
    private final GCMetrics gcMetrics;
    private final HealthMetricsImpl healthCheck;
    private final HttpMetrics httpMetrics;
    private final JsonQueryMetrics jsonQueryMetrics;
    private final LineMetrics lineMetrics;
    private final MetricsRegistry metricsRegistry;
    private final PGMetrics pgMetrics;
    private final Runtime runtime = Runtime.getRuntime();
    private final VirtualLongGauge.StatProvider jvmFreeMemRef = this.runtime::freeMemory;
    private final VirtualLongGauge.StatProvider jvmMaxMemRef = this.runtime::maxMemory;
    private final VirtualLongGauge.StatProvider jvmTotalMemRef = this.runtime::totalMemory;
    private final TableWriterMetrics tableWriterMetrics;
    private final WalMetrics walMetrics;
    private final WorkerMetrics workerMetrics;
    private boolean enabled;

    public Metrics(boolean enabled, MetricsRegistry metricsRegistry) {
        this.enabled = enabled;
        this.gcMetrics = new GCMetrics();
        this.jsonQueryMetrics = new JsonQueryMetrics(metricsRegistry);
        this.httpMetrics = new HttpMetrics(metricsRegistry);
        this.pgMetrics = new PGMetrics(metricsRegistry);
        this.lineMetrics = new LineMetrics(metricsRegistry);
        this.healthCheck = new HealthMetricsImpl(metricsRegistry);
        this.tableWriterMetrics = new TableWriterMetrics(metricsRegistry);
        this.walMetrics = new WalMetrics(metricsRegistry);
        this.createMemoryGauges(metricsRegistry);
        this.metricsRegistry = metricsRegistry;
        this.workerMetrics = new WorkerMetrics(metricsRegistry);
    }

    @Override
    public void clear() {
        this.gcMetrics.clear();
        this.jsonQueryMetrics.clear();
        this.pgMetrics.clear();
        this.lineMetrics.clear();
        this.healthCheck.clear();
        this.tableWriterMetrics.clear();
        this.walMetrics.clear();
        this.workerMetrics.clear();
        this.httpMetrics.clear();
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public MetricsRegistry getRegistry() {
        return this.metricsRegistry;
    }

    public HealthMetricsImpl healthMetrics() {
        return this.healthCheck;
    }

    public HttpMetrics httpMetrics() {
        return this.httpMetrics;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JsonQueryMetrics jsonQueryMetrics() {
        return this.jsonQueryMetrics;
    }

    public LineMetrics lineMetrics() {
        return this.lineMetrics;
    }

    public PGMetrics pgWireMetrics() {
        return this.pgMetrics;
    }

    @Override
    public void scrapeIntoPrometheus(@NotNull BorrowableUtf8Sink sink) {
        this.metricsRegistry.scrapeIntoPrometheus(sink);
        if (this.enabled) {
            this.gcMetrics.scrapeIntoPrometheus(sink);
        }
    }

    public TableWriterMetrics tableWriterMetrics() {
        return this.tableWriterMetrics;
    }

    public WalMetrics walMetrics() {
        return this.walMetrics;
    }

    public WorkerMetrics workerMetrics() {
        return this.workerMetrics;
    }

    private void createMemoryGauges(MetricsRegistry metricsRegistry) {
        for (int i = 0; i < 70; ++i) {
            metricsRegistry.newLongGauge(i);
        }
        metricsRegistry.newVirtualGauge("memory_free_count", Unsafe::getFreeCount);
        metricsRegistry.newVirtualGauge("memory_mem_used", Unsafe::getMemUsed);
        metricsRegistry.newVirtualGauge("memory_malloc_count", Unsafe::getMallocCount);
        metricsRegistry.newVirtualGauge("memory_realloc_count", Unsafe::getReallocCount);
        metricsRegistry.newVirtualGauge("memory_rss", Os::getRss);
        metricsRegistry.newVirtualGauge("memory_jvm_free", this.jvmFreeMemRef);
        metricsRegistry.newVirtualGauge("memory_jvm_total", this.jvmTotalMemRef);
        metricsRegistry.newVirtualGauge("memory_jvm_max", this.jvmMaxMemRef);
    }

    void addScrapable(Target target) {
        this.metricsRegistry.addTarget(target);
    }
}

