/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableFlagResolver;
import io.questdb.std.Chars;
import org.jetbrains.annotations.NotNull;

public class TableFlagResolverImpl
implements TableFlagResolver {
    private final String[] publicTables;
    private final String systemTableNamePrefix;

    public TableFlagResolverImpl(String systemTableNamePrefix) {
        this.systemTableNamePrefix = systemTableNamePrefix;
        this.publicTables = new String[]{systemTableNamePrefix + "telemetry_wal", "telemetry", "telemetry_config", systemTableNamePrefix + "telemetry_mat_view"};
    }

    @Override
    public boolean isPublic(@NotNull CharSequence tableName) {
        int n = this.publicTables.length;
        for (int i = 0; i < n; ++i) {
            if (!Chars.equalsIgnoreCase(tableName, this.publicTables[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSystem(@NotNull CharSequence tableName) {
        return Chars.startsWith(tableName, this.systemTableNamePrefix) || Chars.equalsIgnoreCase(tableName, "telemetry_config") || Chars.equalsIgnoreCase(tableName, "telemetry") || Chars.equalsIgnoreCase(tableName, "_query_trace");
    }
}

