/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.std.Chars;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.GcUtf8String;
import io.questdb.std.str.Sinkable;
import org.jetbrains.annotations.NotNull;

public class TableToken
implements Sinkable {
    @NotNull
    private final GcUtf8String dirName;
    private final boolean dirNameSameAsTableName;
    private final boolean isMatView;
    private final boolean isProtected;
    private final boolean isPublic;
    private final boolean isSystem;
    private final boolean isWal;
    private final int tableId;
    @NotNull
    private final String tableName;

    public TableToken(@NotNull String tableName, @NotNull String dirName, int tableId, boolean isWal, boolean isSystem, boolean isProtected) {
        this(tableName, new GcUtf8String(dirName), tableId, false, isWal, isSystem, isProtected, false);
    }

    public TableToken(@NotNull String tableName, @NotNull String dirName, int tableId, boolean isMatView, boolean isWal, boolean isSystem, boolean isProtected, boolean isPublic) {
        this(tableName, new GcUtf8String(dirName), tableId, isMatView, isWal, isSystem, isProtected, isPublic);
    }

    private TableToken(@NotNull String tableName, @NotNull GcUtf8String dirName, int tableId, boolean isMatView, boolean isWal, boolean isSystem, boolean isProtected, boolean isPublic) {
        this.tableName = tableName;
        this.dirName = dirName;
        this.tableId = tableId;
        this.isMatView = isMatView;
        this.isWal = isWal;
        this.isSystem = isSystem;
        this.isProtected = isProtected;
        this.isPublic = isPublic;
        String dirNameString = dirName.toString();
        this.dirNameSameAsTableName = Chars.startsWith((CharSequence)dirNameString, tableName) && (dirNameString.length() == tableName.length() || dirNameString.length() > tableName.length() && dirNameString.charAt(tableName.length()) == '~');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableToken that = (TableToken)o;
        if (this.tableId != that.tableId) {
            return false;
        }
        if (this.isMatView != that.isMatView) {
            return false;
        }
        if (this.isWal != that.isWal) {
            return false;
        }
        if (this.isSystem != that.isSystem) {
            return false;
        }
        if (this.isProtected != that.isProtected) {
            return false;
        }
        if (!this.tableName.equals(that.tableName)) {
            return false;
        }
        return this.dirName.equals(that.dirName);
    }

    @NotNull
    public String getDirName() {
        return this.dirName.toString();
    }

    @NotNull
    public DirectUtf8Sequence getDirNameUtf8() {
        return this.dirName;
    }

    public int getTableId() {
        return this.tableId;
    }

    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    public int hashCode() {
        return this.tableId;
    }

    public boolean isMatView() {
        return this.isMatView;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public boolean isWal() {
        return this.isWal;
    }

    public TableToken renamed(String newName) {
        return new TableToken(newName, this.dirName, this.tableId, this.isMatView, this.isWal, this.isSystem, this.isProtected, this.isPublic);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        if (this.dirNameSameAsTableName) {
            sink.put(this.dirName);
        } else {
            sink.put("TableToken{tableName=").put(this.tableName).put(", dirName=").put(this.dirName).put('}');
        }
    }

    public String toString() {
        return "TableToken{tableName=" + this.tableName + ", dirName=" + String.valueOf(this.dirName) + ", tableId=" + this.tableId + ", isMatView=" + this.isMatView + ", isWal=" + this.isWal + ", isSystem=" + this.isSystem + ", isProtected=" + this.isProtected + ", isPublic=" + this.isPublic + "}";
    }
}

