/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.Unordered4Map;
import io.questdb.cairo.map.Unordered4MapRecord;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.std.DirectLongLongSortedList;

public final class Unordered4MapCursor
implements MapRecordCursor {
    private final long entrySize;
    private final Unordered4Map map;
    private final Unordered4MapRecord recordA;
    private final Unordered4MapRecord recordB;
    private long address;
    private int count;
    private long memLimit;
    private long memStart;
    private int remaining;
    private long zeroKeyAddress;

    Unordered4MapCursor(Unordered4MapRecord record, Unordered4Map map) {
        this.recordA = record;
        this.recordB = record.clone();
        this.map = map;
        this.entrySize = map.entrySize();
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        if (this.remaining > 0) {
            counter.add(this.remaining);
            this.remaining = 0;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public MapRecord getRecord() {
        return this.recordA;
    }

    @Override
    public MapRecord getRecordB() {
        return this.recordB;
    }

    @Override
    public boolean hasNext() {
        if (this.remaining > 0) {
            if (this.remaining == 1 && this.zeroKeyAddress != 0L) {
                this.recordA.of(this.zeroKeyAddress);
                --this.remaining;
                return true;
            }
            this.recordA.of(this.address);
            this.skipToNonZeroKey();
            --this.remaining;
            return true;
        }
        return false;
    }

    @Override
    public void longTopK(DirectLongLongSortedList list, Function recordFunction) {
        if (this.zeroKeyAddress != 0L) {
            this.recordA.of(this.zeroKeyAddress);
            long v = recordFunction.getLong(this.recordA);
            list.add(this.zeroKeyAddress, v);
        }
        for (long addr = this.memStart; addr < this.memLimit; addr += this.entrySize) {
            if (this.map.isZeroKey(addr)) continue;
            this.recordA.of(addr);
            long v = recordFunction.getLong(this.recordA);
            list.add(addr, v);
        }
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((Unordered4MapRecord)record).of(atRowId);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public void toTop() {
        this.address = this.memStart;
        this.remaining = this.count;
        if (this.count > 0 && (this.zeroKeyAddress == 0L || this.count > 1) && this.map.isZeroKey(this.address)) {
            this.skipToNonZeroKey();
        }
    }

    private void skipToNonZeroKey() {
        do {
            this.address += this.entrySize;
        } while (this.address < this.memLimit && this.map.isZeroKey(this.address));
    }

    Unordered4MapCursor init(long memStart, long memLimit, long zeroKeyAddress, int count) {
        this.memStart = memStart;
        this.memLimit = memLimit;
        this.count = count;
        this.zeroKeyAddress = zeroKeyAddress;
        this.toTop();
        this.recordA.setLimit(memLimit);
        this.recordB.setLimit(memLimit);
        return this;
    }
}

