/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.PoolTenant;
import io.questdb.cairo.pool.ResourcePoolSupervisor;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.wal.seq.TableRecordMetadataSink;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.std.IntList;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class SequencerMetadataPool
extends AbstractMultiTenantPool<SequencerMetadataTenantImpl> {
    private final CairoEngine engine;

    public SequencerMetadataPool(CairoConfiguration configuration, CairoEngine engine) {
        super(configuration, configuration.getMetadataPoolCapacity(), configuration.getInactiveReaderTTL());
        this.engine = engine;
    }

    @Override
    protected byte getListenerSrc() {
        return 3;
    }

    @Override
    protected SequencerMetadataTenantImpl newTenant(TableToken tableToken, AbstractMultiTenantPool.Entry<SequencerMetadataTenantImpl> entry, int index, @Nullable ResourcePoolSupervisor<SequencerMetadataTenantImpl> supervisor) {
        return new SequencerMetadataTenantImpl(this, entry, index, tableToken, this.engine.getTableSequencerAPI());
    }

    public static class SequencerMetadataTenantImpl
    extends GenericRecordMetadata
    implements TableRecordMetadata,
    TableRecordMetadataSink,
    PoolTenant<SequencerMetadataTenantImpl> {
        private final Comparator<TableColumnMetadata> columnOrderComparator = this::compareColumnOrder;
        private final int index;
        private final TableSequencerAPI tableSequencerAPI;
        private AbstractMultiTenantPool.Entry<SequencerMetadataTenantImpl> entry;
        private long metadataVersion;
        private AbstractMultiTenantPool<SequencerMetadataTenantImpl> pool;
        private IntList readColumnOrder;
        private int tableId;
        private TableToken tableToken;

        public SequencerMetadataTenantImpl(AbstractMultiTenantPool<SequencerMetadataTenantImpl> pool, AbstractMultiTenantPool.Entry<SequencerMetadataTenantImpl> entry, int index, TableToken tableToken, TableSequencerAPI tableSequencerAPI) {
            this.pool = pool;
            this.entry = entry;
            this.index = index;
            this.tableSequencerAPI = tableSequencerAPI;
            this.tableToken = tableToken;
            tableSequencerAPI.getTableMetadata(tableToken, this);
        }

        @Override
        public void addColumn(String columnName, int columnType, boolean columnIndexed, int indexValueBlockCapacity, boolean symbolTableStatic, int writerIndex, boolean isDedupKey, boolean symbolIsCached, int symbolCapacity) {
            if ((long)columnType > -1L) {
                this.add(new TableColumnMetadata(columnName, columnType, columnIndexed, indexValueBlockCapacity, symbolTableStatic, null, writerIndex, isDedupKey, 0, symbolIsCached, symbolCapacity));
            }
        }

        @Override
        public void close() {
            if (this.pool != null && this.getEntry() != null) {
                this.pool.returnToPool(this);
            }
        }

        @Override
        public AbstractMultiTenantPool.Entry<SequencerMetadataTenantImpl> getEntry() {
            return this.entry;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public long getMetadataVersion() {
            return this.metadataVersion;
        }

        @Override
        public int getTableId() {
            return this.tableId;
        }

        @Override
        public TableToken getTableToken() {
            return this.tableToken;
        }

        @Override
        public void goodbye() {
            this.entry = null;
            this.pool = null;
        }

        @Override
        public boolean isDedupKey(int columnIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWalEnabled() {
            return true;
        }

        @Override
        public void of(TableToken tableToken, int tableId, int timestampIndex, int compressedTimestampIndex, boolean suspended, long structureVersion, int columnCount, @Nullable IntList readColumnOrder) {
            this.tableToken = tableToken;
            this.tableId = tableId;
            this.timestampIndex = compressedTimestampIndex;
            this.metadataVersion = structureVersion;
            if (readColumnOrder != null) {
                this.readColumnOrder = readColumnOrder;
                this.columnMetadata.sort(this.columnOrderComparator);
                this.readColumnOrder = null;
                this.columnNameIndexMap.clear();
                for (int i = 0; i < columnCount; ++i) {
                    TableColumnMetadata column = (TableColumnMetadata)this.columnMetadata.getQuick(i);
                    this.columnNameIndexMap.put(column.getColumnName(), i);
                    if (column.getWriterIndex() != timestampIndex) continue;
                    this.timestampIndex = i;
                }
            }
        }

        @Override
        public void refresh(@Nullable ResourcePoolSupervisor<SequencerMetadataTenantImpl> supervisor) {
            this.tableSequencerAPI.reloadMetadataConditionally(this.tableToken, this.getMetadataVersion(), this);
        }

        @Override
        public void updateTableToken(TableToken tableToken) {
            this.tableToken = tableToken;
        }

        private int compareColumnOrder(TableColumnMetadata a, TableColumnMetadata b) {
            int aOrder = this.readColumnOrder.getQuick(a.getWriterIndex());
            int bOrder = this.readColumnOrder.getQuick(b.getWriterIndex());
            return Integer.compare(aOrder, bOrder);
        }
    }
}

