/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.FunctionExtension;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StatefulAtom;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.BinarySequence;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8Sequence;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Function
extends Closeable,
StatefulAtom,
Plannable {
    public static void init(ObjList<? extends Function> clones, SymbolTableSource symbolTableSource, SqlExecutionContext executionContext, @Nullable Function prototypeFunction) throws SqlException {
        int i;
        int n;
        if (prototypeFunction != null) {
            n = clones.size();
            for (i = 0; i < n; ++i) {
                prototypeFunction.offerStateTo(clones.getQuick(i));
            }
        }
        n = clones.size();
        for (i = 0; i < n; ++i) {
            clones.getQuick(i).init(symbolTableSource, executionContext);
        }
    }

    public static void initNc(ObjList<? extends Function> args, SymbolTableSource symbolTableSource, SqlExecutionContext executionContext, @Nullable Function prototypeFunction) throws SqlException {
        if (args != null) {
            Function.init(args, symbolTableSource, executionContext, prototypeFunction);
        }
    }

    default public void assignType(int type, BindVariableService bindVariableService) throws SqlException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void close() {
    }

    default public void cursorClosed() {
    }

    default public FunctionExtension extendedOps() {
        return null;
    }

    public ArrayView getArray(Record var1);

    public BinarySequence getBin(Record var1);

    public long getBinLen(Record var1);

    public boolean getBool(Record var1);

    public byte getByte(Record var1);

    public char getChar(Record var1);

    public long getDate(Record var1);

    public double getDouble(Record var1);

    public float getFloat(Record var1);

    public byte getGeoByte(Record var1);

    public int getGeoInt(Record var1);

    public long getGeoLong(Record var1);

    public short getGeoShort(Record var1);

    public int getIPv4(Record var1);

    public int getInt(Record var1);

    @NotNull
    public Interval getInterval(Record var1);

    public long getLong(Record var1);

    public long getLong128Hi(Record var1);

    public long getLong128Lo(Record var1);

    public void getLong256(Record var1, CharSink<?> var2);

    public Long256 getLong256A(Record var1);

    public Long256 getLong256B(Record var1);

    default public RecordMetadata getMetadata() {
        return null;
    }

    default public String getName() {
        return this.getClass().getName();
    }

    public RecordCursorFactory getRecordCursorFactory();

    public short getShort(Record var1);

    public CharSequence getStrA(Record var1);

    public CharSequence getStrB(Record var1);

    public int getStrLen(Record var1);

    public CharSequence getSymbol(Record var1);

    public CharSequence getSymbolB(Record var1);

    public long getTimestamp(Record var1);

    public int getType();

    @Nullable
    public Utf8Sequence getVarcharA(Record var1);

    @Nullable
    public Utf8Sequence getVarcharB(Record var1);

    public int getVarcharSize(Record var1);

    default public boolean isConstant() {
        return false;
    }

    default public boolean isConstantOrRuntimeConstant() {
        return this.isConstant() || this.isRuntimeConstant();
    }

    default public boolean isNonDeterministic() {
        return false;
    }

    default public boolean isNullConstant() {
        return false;
    }

    default public boolean isOperator() {
        return false;
    }

    default public boolean isRandom() {
        return false;
    }

    default public boolean isRuntimeConstant() {
        return false;
    }

    default public boolean isThreadSafe() {
        return false;
    }

    default public boolean isUndefined() {
        return this.getType() == 0;
    }

    default public void memoize(Record record) {
    }

    default public void offerStateTo(Function that) {
    }

    default public boolean shouldMemoize() {
        return false;
    }

    default public boolean supportsParallelism() {
        return true;
    }

    default public boolean supportsRandomAccess() {
        return true;
    }

    @Override
    default public void toPlan(PlanSink sink) {
        sink.val(this.getName()).val("()");
    }

    default public void toTop() {
    }
}

