/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.std.str.Path;
import org.jetbrains.annotations.NotNull;

class WalApplySqlExecutionContext
extends SqlExecutionContextImpl {
    private TableToken tableToken;

    WalApplySqlExecutionContext(CairoEngine engine, int sharedQueryWorkerCount) {
        super(engine, sharedQueryWorkerCount);
        if (!engine.getConfiguration().isWalApplyParallelSqlEnabled()) {
            this.setParallelFilterEnabled(false);
            this.setParallelGroupByEnabled(false);
            this.setParallelTopKEnabled(false);
            this.setParallelReadParquetEnabled(false);
        }
    }

    @Override
    @NotNull
    public SqlExecutionCircuitBreaker getCircuitBreaker() {
        return this.getSimpleCircuitBreaker();
    }

    @Override
    public TableMetadata getMetadataForWrite(TableToken tableToken, long desiredVersion) {
        return this.getCairoEngine().getTableMetadata(this.tableToken, desiredVersion);
    }

    @Override
    public TableReader getReader(TableToken tableToken, long version) {
        return this.getCairoEngine().getReader(this.tableToken, version);
    }

    @Override
    public TableReader getReader(TableToken tableName) {
        return this.getCairoEngine().getReader(this.tableToken);
    }

    @Override
    public int getTableStatus(Path path, CharSequence tableName) {
        return this.getCairoEngine().getTableStatus(path, this.tableToken.getTableName());
    }

    @Override
    public int getTableStatus(Path path, TableToken tableToken) {
        return this.getCairoEngine().getTableStatus(path, this.tableToken);
    }

    @Override
    public TableToken getTableToken(CharSequence tableName, int lo, int hi) {
        return this.tableToken;
    }

    @Override
    public TableToken getTableToken(CharSequence tableName) {
        return this.tableToken;
    }

    @Override
    public TableToken getTableTokenIfExists(CharSequence tableName) {
        return this.tableToken;
    }

    @Override
    public TableToken getTableTokenIfExists(CharSequence tableName, int lo, int hi) {
        return this.tableToken;
    }

    @Override
    public boolean isUninterruptible() {
        return true;
    }

    @Override
    public boolean isWalApplication() {
        return true;
    }

    public void remapTableNameResolutionTo(TableToken tableToken) {
        this.tableToken = tableToken;
    }

    @Override
    public boolean shouldLogSql() {
        return false;
    }
}

