/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.arr.BorrowedFlatArrayView;
import io.questdb.cutlass.line.tcp.DirectUtf8SymbolLookup;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.Uuid;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.FlyweightDirectUtf16Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;

public class LineTcpEventBuffer {
    private final BorrowedArray borrowedDirectArrayView = new BorrowedArray();
    private final long bufLo;
    private final long bufSize;
    private final FlyweightDirectUtf16Sink tempSink = new FlyweightDirectUtf16Sink();
    private final FlyweightDirectUtf16Sink tempSinkB = new FlyweightDirectUtf16Sink();
    private final DirectUtf8String utf8Sequence = new DirectUtf8String();

    public LineTcpEventBuffer(long bufLo, long bufSize) {
        this.bufLo = bufLo;
        this.bufSize = bufLo + bufSize;
    }

    public long addArray(long address, BorrowedArray arrayView) {
        if (arrayView == null) {
            return this.addNull(address);
        }
        int dims = arrayView.getDimCount();
        BorrowedFlatArrayView values = (BorrowedFlatArrayView)arrayView.flatView();
        int totalLength = 8 + dims * 4 + values.size();
        this.checkCapacity(address, totalLength + 1);
        Unsafe.getUnsafe().putByte(address, (byte)14);
        Unsafe.getUnsafe().putInt(++address, totalLength);
        Unsafe.getUnsafe().putInt(address += 4L, arrayView.getType());
        address += 4L;
        for (int i = 0; i < dims; ++i) {
            Unsafe.getUnsafe().putInt(address, arrayView.getDimLen(i));
            address += 4L;
        }
        Vect.memcpy(address, values.ptr(), values.size());
        return address += (long)values.size();
    }

    public long addBoolean(long address, byte value) {
        this.checkCapacity(address, 2);
        Unsafe.getUnsafe().putByte(address, (byte)6);
        Unsafe.getUnsafe().putByte(address + 1L, value);
        return address + 1L + 1L;
    }

    public long addByte(long address, byte value) {
        this.checkCapacity(address, 2);
        Unsafe.getUnsafe().putByte(address, (byte)18);
        Unsafe.getUnsafe().putByte(address + 1L, value);
        return address + 1L + 1L;
    }

    public long addChar(long address, char value) {
        this.checkCapacity(address, 3);
        Unsafe.getUnsafe().putByte(address, (byte)20);
        Unsafe.getUnsafe().putChar(address + 1L, value);
        return address + 2L + 1L;
    }

    public long addColumnIndex(long address, int colIndex) {
        this.checkCapacity(address, 4);
        Unsafe.getUnsafe().putInt(address, colIndex);
        return address + 4L;
    }

    public long addColumnName(long address, CharSequence colName, CharSequence principal) {
        int colNameLen = colName.length();
        int principalLen = principal != null ? principal.length() : 0;
        int colNameCapacity = 4 + 2 * colNameLen;
        int fullCapacity = colNameCapacity + 4 + 2 * principalLen;
        this.checkCapacity(address, fullCapacity);
        Unsafe.getUnsafe().putInt(address, -colNameLen);
        Chars.copyStrChars(colName, 0, colNameLen, address + 4L);
        Unsafe.getUnsafe().putInt(address + (long)colNameCapacity, principalLen);
        if (principalLen > 0) {
            Chars.copyStrChars(principal, 0, principalLen, address + (long)colNameCapacity + 4L);
        }
        return address + (long)fullCapacity;
    }

    public long addDate(long address, long value) {
        this.checkCapacity(address, 9);
        Unsafe.getUnsafe().putByte(address, (byte)19);
        Unsafe.getUnsafe().putLong(address + 1L, value);
        return address + 8L + 1L;
    }

    public void addDesignatedTimestamp(long address, long timestamp) {
        this.checkCapacity(address, 9);
        Unsafe.getUnsafe().putLong(address, timestamp);
    }

    public long addDouble(long address, double value) {
        this.checkCapacity(address, 9);
        Unsafe.getUnsafe().putByte(address, (byte)16);
        Unsafe.getUnsafe().putDouble(address + 1L, value);
        return address + 8L + 1L;
    }

    public long addFloat(long address, float value) {
        this.checkCapacity(address, 5);
        Unsafe.getUnsafe().putByte(address, (byte)2);
        Unsafe.getUnsafe().putFloat(address + 1L, value);
        return address + 4L + 1L;
    }

    public long addGeoHash(long address, DirectUtf8Sequence value, int colTypeMeta) {
        long geohash;
        try {
            geohash = GeoHashes.fromAsciiTruncatingNl(value.lo(), value.hi(), Numbers.decodeLowShort(colTypeMeta));
        }
        catch (NumericException e) {
            geohash = -1L;
        }
        switch (Numbers.decodeHighShort(colTypeMeta)) {
            default: {
                this.checkCapacity(address, 9);
                Unsafe.getUnsafe().putByte(address, (byte)12);
                Unsafe.getUnsafe().putLong(address + 1L, geohash);
                return address + 8L + 1L;
            }
            case 16: {
                this.checkCapacity(address, 5);
                Unsafe.getUnsafe().putByte(address, (byte)11);
                Unsafe.getUnsafe().putInt(address + 1L, (int)geohash);
                return address + 4L + 1L;
            }
            case 15: {
                this.checkCapacity(address, 3);
                Unsafe.getUnsafe().putByte(address, (byte)10);
                Unsafe.getUnsafe().putShort(address + 1L, (short)geohash);
                return address + 2L + 1L;
            }
            case 14: 
        }
        this.checkCapacity(address, 2);
        Unsafe.getUnsafe().putByte(address, (byte)9);
        Unsafe.getUnsafe().putByte(address + 1L, (byte)geohash);
        return address + 1L + 1L;
    }

    public long addInt(long address, int value) {
        this.checkCapacity(address, 5);
        Unsafe.getUnsafe().putByte(address, (byte)3);
        Unsafe.getUnsafe().putInt(address + 1L, value);
        return address + 4L + 1L;
    }

    public long addLong(long address, long value) {
        this.checkCapacity(address, 9);
        Unsafe.getUnsafe().putByte(address, (byte)15);
        Unsafe.getUnsafe().putLong(address + 1L, value);
        return address + 8L + 1L;
    }

    public long addLong256(long address, DirectUtf8Sequence value) {
        return this.addString(address, value, (byte)7);
    }

    public long addNull(long address) {
        this.checkCapacity(address, 1);
        Unsafe.getUnsafe().putByte(address, (byte)0);
        return address + 1L;
    }

    public void addNumOfColumns(long address, int numOfColumns) {
        this.checkCapacity(address, 4);
        Unsafe.getUnsafe().putInt(address, numOfColumns);
    }

    public long addShort(long address, short value) {
        this.checkCapacity(address, 3);
        Unsafe.getUnsafe().putByte(address, (byte)17);
        Unsafe.getUnsafe().putShort(address + 1L, value);
        return address + 2L + 1L;
    }

    public long addString(long address, DirectUtf8Sequence value) {
        return this.addString(address, value, (byte)4);
    }

    public void addStructureVersion(long address, long structureVersion) {
        this.checkCapacity(address, 8);
        Unsafe.getUnsafe().putLong(address, structureVersion);
    }

    public long addSymbol(long address, DirectUtf8Sequence value, DirectUtf8SymbolLookup symbolLookup) {
        int maxLen = 2 * value.size();
        this.checkCapacity(address, 5 + maxLen);
        long strPos = address + 1L + 4L;
        this.tempSink.of(strPos, strPos + (long)maxLen);
        int symIndex = symbolLookup.keyOf(value);
        if (symIndex != -2) {
            Unsafe.getUnsafe().putByte(address, (byte)8);
            Unsafe.getUnsafe().putInt(address + 1L, symIndex);
            return address + 4L + 1L;
        }
        if (value.isAscii()) {
            this.tempSink.put(value);
        } else {
            Utf8s.utf8ToUtf16(value, this.tempSink);
        }
        int length = this.tempSink.length();
        Unsafe.getUnsafe().putByte(address, (byte)1);
        Unsafe.getUnsafe().putInt(address + 1L, length);
        return address + (long)length * 2L + 4L + 1L;
    }

    public long addTimestamp(long address, long value) {
        this.checkCapacity(address, 9);
        Unsafe.getUnsafe().putByte(address, (byte)13);
        Unsafe.getUnsafe().putLong(address + 1L, value);
        return address + 8L + 1L;
    }

    public long addUuid(long offset, DirectUtf8Sequence value) throws NumericException {
        this.checkCapacity(offset, 17);
        CharSequence csView = value.asAsciiCharSequence();
        Uuid.checkDashesAndLength(csView);
        long hi = Uuid.parseHi(csView);
        long lo = Uuid.parseLo(csView);
        Unsafe.getUnsafe().putByte(offset, (byte)21);
        Unsafe.getUnsafe().putLong(++offset, lo);
        Unsafe.getUnsafe().putLong(offset += 8L, hi);
        return offset + 8L;
    }

    public long addVarchar(long address, DirectUtf8Sequence value) {
        int valueSize = value.size();
        int totalSize = 6 + valueSize;
        this.checkCapacity(address, totalSize);
        Unsafe.getUnsafe().putByte(address++, (byte)22);
        Unsafe.getUnsafe().putByte(address++, (byte)(!value.isAscii() ? 1 : 0));
        Unsafe.getUnsafe().putInt(address, valueSize);
        value.writeTo(address += 4L, 0, valueSize);
        return address + (long)valueSize;
    }

    public long columnValueLength(byte entityType, long offset) {
        switch (entityType) {
            case 1: 
            case 4: 
            case 7: {
                CharSequence cs = this.readUtf16Chars(offset);
                return (long)cs.length() * 2L + 4L;
            }
            case 6: 
            case 9: 
            case 18: {
                return 1L;
            }
            case 10: 
            case 17: {
                return 2L;
            }
            case 20: {
                return 2L;
            }
            case 3: 
            case 8: 
            case 11: {
                return 4L;
            }
            case 12: 
            case 13: 
            case 15: 
            case 19: {
                return 8L;
            }
            case 2: {
                return 4L;
            }
            case 16: {
                return 8L;
            }
            case 21: {
                return 16L;
            }
            case 14: {
                return this.readInt(offset);
            }
            case 0: {
                return 0L;
            }
        }
        throw new UnsupportedOperationException("entityType " + entityType + " is not implemented!");
    }

    public long getAddress() {
        return this.bufLo;
    }

    public long getAddressAfterHeader() {
        return this.bufLo + 16L + 4L;
    }

    public ArrayView readArray(long address) {
        int totalSize = this.readInt(address);
        int type = this.readInt(address += 4L);
        int dims = ColumnType.decodeArrayDimensionality(type);
        this.borrowedDirectArrayView.of(type, address += 4L, address + (long)dims * 4L, totalSize - (dims + 2) * 4);
        return this.borrowedDirectArrayView;
    }

    public byte readByte(long address) {
        return Unsafe.getUnsafe().getByte(address);
    }

    public char readChar(long address) {
        return Unsafe.getUnsafe().getChar(address);
    }

    public double readDouble(long address) {
        return Unsafe.getUnsafe().getDouble(address);
    }

    public float readFloat(long address) {
        return Unsafe.getUnsafe().getFloat(address);
    }

    public int readInt(long address) {
        return Unsafe.getUnsafe().getInt(address);
    }

    public long readLong(long address) {
        return Unsafe.getUnsafe().getLong(address);
    }

    public short readShort(long address) {
        return Unsafe.getUnsafe().getShort(address);
    }

    public CharSequence readUtf16Chars(long address) {
        int len = this.readInt(address);
        return this.readUtf16Chars(address + 4L, len);
    }

    public CharSequence readUtf16Chars(long address, int length) {
        return this.tempSink.asCharSequence(address, address + (long)length * 2L);
    }

    public CharSequence readUtf16CharsB(long address, int length) {
        return this.tempSinkB.asCharSequence(address, address + (long)length * 2L);
    }

    public Utf8Sequence readVarchar(long address, boolean ascii) {
        int size = this.readInt(address);
        return this.utf8Sequence.of(address + 4L, address + 4L + (long)size, ascii);
    }

    private long addString(long address, DirectUtf8Sequence value, byte entityTypeString) {
        int maxLen = 2 * value.size();
        this.checkCapacity(address, 5 + maxLen);
        long strPos = address + 1L + 4L;
        this.tempSink.of(strPos, strPos + (long)maxLen);
        if (value.isAscii()) {
            this.tempSink.put(value);
        } else {
            Utf8s.utf8ToUtf16Unchecked(value, this.tempSink);
        }
        int length = this.tempSink.length();
        Unsafe.getUnsafe().putByte(address, entityTypeString);
        Unsafe.getUnsafe().putInt(address + 1L, length);
        return address + (long)length * 2L + 4L + 1L;
    }

    private void checkCapacity(long address, int length) {
        if (address + (long)length > this.bufSize) {
            throw CairoException.critical(0).put("queue buffer overflow");
        }
    }
}

