/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cutlass.http.ex.NotEnoughLinesException;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.TextException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.io.Closeable;
import java.util.Arrays;

public class TextDelimiterScanner
implements Closeable {
    private static final double DOUBLE_TOLERANCE = 5.0E-7;
    private static final Log LOG;
    private static final byte[] potentialDelimiterBytes;
    private static final byte[] priorities;
    private final int lineCountLimit;
    private final long matrix;
    private final int matrixRowSize;
    private final int matrixSize;
    private final double maxRequiredDelimiterStdDev;
    private final double maxRequiredLineLengthStdDev;
    private CharSequence tableName;

    public TextDelimiterScanner(TextConfiguration configuration) {
        try {
            this.lineCountLimit = configuration.getTextAnalysisMaxLines();
            this.matrixRowSize = 1024;
            this.matrixSize = this.matrixRowSize * this.lineCountLimit;
            this.matrix = Unsafe.malloc(this.matrixSize, 57);
            this.maxRequiredDelimiterStdDev = configuration.getMaxRequiredDelimiterStdDev();
            this.maxRequiredLineLengthStdDev = configuration.getMaxRequiredLineLengthStdDev();
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    @Override
    public void close() {
        Unsafe.free(this.matrix, this.matrixSize, 57);
    }

    private static void configurePriority(byte value, byte priority) {
        assert (value > -1);
        TextDelimiterScanner.priorities[value] = priority;
    }

    private static byte getPriority(byte value) {
        return priorities[value];
    }

    private void bumpCountAt(int line, byte bytePosition, int increment) {
        if (bytePosition > 0) {
            long pos = this.matrix + ((long)line * (long)this.matrixRowSize + (long)(bytePosition * 4));
            Unsafe.getUnsafe().putInt(pos, Unsafe.getUnsafe().getInt(pos) + increment);
        }
    }

    byte scan(long address, long hi) throws TextException {
        int lineCount = 0;
        boolean quotes = false;
        long cursor = address;
        boolean delayedClosingQuote = false;
        long byteBitFieldLo = 0L;
        long byteBitFieldHi = 0L;
        int lineLen = 0;
        Vect.memset(this.matrix, this.matrixSize, 0);
        block4: while (cursor < hi && lineCount < this.lineCountLimit) {
            byte b = Unsafe.getUnsafe().getByte(cursor++);
            if (delayedClosingQuote) {
                delayedClosingQuote = false;
                if (b == 34) {
                    ++lineLen;
                    continue;
                }
                quotes = false;
            }
            if (quotes) {
                if (b == 34) {
                    delayedClosingQuote = true;
                }
                ++lineLen;
                continue;
            }
            switch (b) {
                case 10: 
                case 13: {
                    if (lineLen <= 0) continue block4;
                    this.bumpCountAt(lineCount, (byte)65, lineLen);
                    byteBitFieldHi |= 0x4000000000000000L;
                    ++lineCount;
                    lineLen = 0;
                    continue block4;
                }
                case 34: {
                    ++lineLen;
                    quotes = true;
                    continue block4;
                }
            }
            ++lineLen;
            if (potentialDelimiterBytes[b & 0xFF] != 1) continue;
            this.bumpCountAt(lineCount, b, 1);
            if (b < 64) {
                byteBitFieldLo |= 1L << b;
                continue;
            }
            byteBitFieldHi |= 1L << 127 - b;
        }
        byte delimiter = -128;
        if (lineCount < 2) {
            LOG.info().$("not enough lines [table=").$safe(this.tableName).$(']').$();
            throw NotEnoughLinesException.$("not enough lines [table=").put(this.tableName).put(']');
        }
        double lastDelimiterStdDev = Double.POSITIVE_INFINITY;
        byte lastDelimiterPriority = -128;
        double lastDelimiterMean = 0.0;
        double lineLengthStdDev = 0.0;
        int n = 128;
        for (int i = 0; i < n; ++i) {
            boolean set;
            if (i < 64) {
                set = (byteBitFieldLo & 1L << i) != 0L;
            } else {
                boolean bl = set = (byteBitFieldHi & 1L << 127 - i) != 0L;
            }
            if (!set) continue;
            long offset = (long)i * 4L;
            long sum = 0L;
            for (int l = 0; l < lineCount; ++l) {
                sum += (long)Unsafe.getUnsafe().getInt(this.matrix + offset);
                offset += (long)this.matrixRowSize;
            }
            offset = (long)i * 4L;
            double mean = (double)sum / (double)lineCount;
            if (!(mean > 0.0)) continue;
            double squareSum = 0.0;
            for (int l = 0; l < lineCount; ++l) {
                double x = (double)Unsafe.getUnsafe().getInt(this.matrix + offset) - mean;
                squareSum += x * x;
                offset += (long)this.matrixRowSize;
            }
            double stdDev = Math.sqrt(squareSum / (double)lineCount);
            if (i == 65) {
                lineLengthStdDev = stdDev;
                continue;
            }
            byte thisPriority = TextDelimiterScanner.getPriority((byte)i);
            if (!(stdDev < lastDelimiterStdDev) && (!(Math.abs(stdDev - lastDelimiterStdDev) < 5.0E-7) || lastDelimiterPriority >= thisPriority && (lastDelimiterPriority != thisPriority || !(lastDelimiterMean > mean)))) continue;
            lastDelimiterStdDev = stdDev;
            lastDelimiterPriority = thisPriority;
            lastDelimiterMean = mean;
            delimiter = (byte)i;
        }
        if (delimiter != 46 && lastDelimiterStdDev < this.maxRequiredDelimiterStdDev) {
            LOG.info().$("scan result [table=`").$safe(this.tableName).$("`, delimiter='").$((char)delimiter).$("', priority=").$(lastDelimiterPriority).$(", mean=").$(lastDelimiterMean).$(", stddev=").$(lastDelimiterStdDev).$(']').$();
            return delimiter;
        }
        if (lineLengthStdDev < this.maxRequiredLineLengthStdDev) {
            return 44;
        }
        LOG.info().$("min deviation is too high [delimiterStdDev=").$(lastDelimiterStdDev).$(", delimiterMaxStdDev=").$(this.maxRequiredDelimiterStdDev).$(", lineLengthStdDev=").$(lineLengthStdDev).$(", lineLengthMaxStdDev=").$(this.maxRequiredLineLengthStdDev).$(", lineCountLimit=").$(this.lineCountLimit).$(", lineCount=").$(lineCount).$(']').$();
        throw TextException.$("min deviation is too high [delimiterStdDev=").put(lastDelimiterStdDev).put(", delimiterMaxStdDev=").put(this.maxRequiredDelimiterStdDev).put(", lineLengthStdDev=").put(lineLengthStdDev).put(", lineLengthMaxStdDev=").put(this.maxRequiredLineLengthStdDev).put(", lineCountLimit=").put(this.lineCountLimit).put(", lineCount=").put(lineCount).put(']');
    }

    void setTableName(CharSequence tableName) {
        this.tableName = tableName;
    }

    static {
        int i;
        LOG = LogFactory.getLog(TextDelimiterScanner.class);
        potentialDelimiterBytes = new byte[256];
        priorities = new byte[128];
        TextDelimiterScanner.configurePriority((byte)44, (byte)10);
        TextDelimiterScanner.configurePriority((byte)9, (byte)10);
        TextDelimiterScanner.configurePriority((byte)124, (byte)10);
        TextDelimiterScanner.configurePriority((byte)58, (byte)9);
        TextDelimiterScanner.configurePriority((byte)32, (byte)8);
        TextDelimiterScanner.configurePriority((byte)59, (byte)8);
        Arrays.fill(potentialDelimiterBytes, (byte)0);
        for (i = 1; i < 48; ++i) {
            TextDelimiterScanner.potentialDelimiterBytes[i] = 1;
        }
        for (i = 58; i < 65; ++i) {
            TextDelimiterScanner.potentialDelimiterBytes[i] = 1;
        }
        for (i = 90; i < 97; ++i) {
            TextDelimiterScanner.potentialDelimiterBytes[i] = 1;
        }
        for (i = 123; i < 255; ++i) {
            TextDelimiterScanner.potentialDelimiterBytes[i] = 1;
        }
    }
}

