/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnTaskJob;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeConverter;
import io.questdb.cairo.ColumnVersionWriter;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.ColumnConversionOffsetSink;
import io.questdb.griffin.PurgingOperator;
import io.questdb.griffin.SymbolMapWriterLite;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.tasks.ColumnTask;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class ConvertOperatorImpl
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ConvertOperatorImpl.class);
    private final long appendPageSize;
    private final AtomicInteger asyncProcessingErrorCount = new AtomicInteger();
    private final ColumnVersionWriter columnVersionWriter;
    private final CairoConfiguration configuration;
    private final SOUnboundedCountDownLatch countDownLatch;
    private final FilesFacade ff;
    private final int fileOpenOpts;
    private final MessageBus messageBus;
    private final ColumnConversionOffsetSink noopConversionOffsetSink = new ColumnConversionOffsetSink(){

        @Override
        public void setDestSizes(long primarySize, long auxSize) {
        }

        @Override
        public void setSrcOffsets(long primaryOffset, long auxOffset) {
        }
    };
    private final Path path;
    private final PurgingOperator purgingOperator;
    private final int rootLen;
    private final TableWriter tableWriter;
    private final MicrosecondClock timer;
    private CharSequence columnName;
    private long fixedFd;
    private int partitionUpdated;
    private SymbolMapReaderImpl symbolMapReader;
    private SymbolMapper symbolMapper;
    private final TableWriter.ColumnTaskHandler cthConvertPartitionHandler = this::cthConvertPartitionHandler;
    private long varFd;

    public ConvertOperatorImpl(CairoConfiguration configuration, TableWriter tableWriter, ColumnVersionWriter columnVersionWriter, Path path, int rootLen, PurgingOperator purgingOperator, MessageBus messageBus) {
        this.configuration = configuration;
        this.tableWriter = tableWriter;
        this.columnVersionWriter = columnVersionWriter;
        this.rootLen = rootLen;
        this.purgingOperator = purgingOperator;
        this.fileOpenOpts = configuration.getWriterFileOpenOpts();
        this.ff = configuration.getFilesFacade();
        this.path = path;
        this.appendPageSize = configuration.getDataAppendPageSize();
        this.messageBus = messageBus;
        this.countDownLatch = new SOUnboundedCountDownLatch();
        this.timer = configuration.getMicrosecondClock();
    }

    @Override
    public void close() {
    }

    public void convertColumn(@NotNull String columnName, int existingColIndex, int existingType, boolean existingIndexed, int columnIndex, int newType) {
        this.clear();
        this.partitionUpdated = 0;
        this.convertColumn0(columnName, existingColIndex, existingType, existingIndexed, columnIndex, newType);
    }

    public void finishColumnConversion() {
        if (this.partitionUpdated > 0 && this.asyncProcessingErrorCount.get() == 0 && !this.tableWriter.isDistressed()) {
            this.partitionUpdated = 0;
            this.purgingOperator.purge(this.path.trimTo(this.rootLen), this.tableWriter.getTableToken(), this.tableWriter.getPartitionBy(), this.tableWriter.checkScoreboardHasReadersBeforeLastCommittedTxn(), this.tableWriter.getTruncateVersion(), this.tableWriter.getTxn());
        }
        this.clear();
    }

    private void clear() {
        this.purgingOperator.clear();
        Misc.free(this.symbolMapReader);
    }

    private void closeFds(long srcFixFd, long srcVarFd, long dstFixFd, long dstVarFd) {
        LOG.debug().$("closing fds[srcFixFd=").$(srcFixFd).$(", srcVarFd=").$(srcVarFd).$(", dstFixFd=").$(dstFixFd).$(", dstVarFd=").$(dstVarFd).I$();
        this.ff.close(srcFixFd);
        this.ff.close(srcVarFd);
        this.ff.close(dstFixFd);
        this.ff.close(dstVarFd);
    }

    private void consumeConversionTasks(RingQueue<ColumnTask> queue, int queuedCount, boolean checkStatus) {
        MCSequence subSeq = this.messageBus.getColumnTaskSubSeq();
        while (!this.countDownLatch.done(queuedCount)) {
            long cursor = subSeq.next();
            if (cursor > -1L) {
                ColumnTaskJob.processColumnTask(queue.get(cursor), cursor, subSeq);
                continue;
            }
            Os.pause();
        }
        if (checkStatus && this.asyncProcessingErrorCount.get() > 0) {
            throw CairoException.critical(0).put("column conversion failed, see logs for details [table=").put(this.tableWriter.getTableToken()).put(", tableDir=").put(this.tableWriter.getTableToken().getDirName()).put(", column=").put(this.columnName).put(']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertColumn0(@NotNull String columnName, int existingColIndex, int existingType, boolean existingIndexed, int columnIndex, int newType) {
        try {
            this.columnName = columnName;
            if (ColumnType.isSymbol(newType)) {
                if (this.symbolMapper == null) {
                    this.symbolMapper = new SymbolMapper();
                }
                this.symbolMapper.of(this.tableWriter, columnIndex);
            }
            if (ColumnType.isSymbol(existingType)) {
                if (this.symbolMapReader == null) {
                    this.symbolMapReader = new SymbolMapReaderImpl();
                }
                long existingColNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(existingColIndex);
                int symbolCount = this.tableWriter.getSymbolMapWriter(existingColIndex).getSymbolCount();
                this.symbolMapReader.of(this.configuration, this.path, columnName, existingColNameTxn, symbolCount);
            }
            int queueCount = 0;
            this.countDownLatch.reset();
            this.asyncProcessingErrorCount.set(0);
            long start = this.timer.getTicks();
            long totalRows = 0L;
            int n = this.tableWriter.getPartitionCount();
            for (int partitionIndex = 0; partitionIndex < n; ++partitionIndex) {
                if (this.asyncProcessingErrorCount.get() != 0) continue;
                try {
                    long partitionTimestamp = this.tableWriter.getPartitionTimestamp(partitionIndex);
                    long maxRow = this.tableWriter.getPartitionSize(partitionIndex);
                    long columnTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, existingColIndex);
                    if (columnTop > -1L) {
                        long rowCount = maxRow - columnTop;
                        long partitionNameTxn = this.tableWriter.getPartitionNameTxn(partitionIndex);
                        if (rowCount > 0L) {
                            this.path.trimTo(this.rootLen);
                            TableUtils.setPathForNativePartition(this.path, this.tableWriter.getPartitionBy(), partitionTimestamp, partitionNameTxn);
                            int pathTrimToLen = this.path.size();
                            long srcFixFd = -1L;
                            long srcVarFd = -1L;
                            long dstFixFd = -1L;
                            long dstVarFd = -1L;
                            try {
                                this.openColumnsRO(columnName, partitionTimestamp, existingColIndex, existingType, pathTrimToLen);
                                srcFixFd = this.fixedFd;
                                srcVarFd = this.varFd;
                                this.openColumnsRW(columnName, partitionTimestamp, columnIndex, newType, pathTrimToLen);
                                dstFixFd = this.fixedFd;
                                dstVarFd = this.varFd;
                                LOG.info().$("converting column [at=").$safe(this.path.trimTo(pathTrimToLen)).$(", column=").$safe(columnName).$(", from=").$(ColumnType.nameOf(existingType)).$(", to=").$(ColumnType.nameOf(newType)).$(", rowCount=").$(rowCount).I$();
                                totalRows += rowCount;
                            }
                            catch (Throwable th) {
                                this.closeFds(srcFixFd, srcVarFd, dstFixFd, dstVarFd);
                                throw th;
                            }
                            if (this.dispatchConvertColumnPartitionTask(existingType, newType, srcFixFd, srcVarFd, dstFixFd, dstVarFd, rowCount, partitionTimestamp)) {
                                ++queueCount;
                            }
                        }
                        long existingColTxnVer = this.tableWriter.getColumnNameTxn(partitionTimestamp, existingColIndex);
                        this.purgingOperator.add(existingColIndex, columnName, existingType, existingIndexed, existingColTxnVer, partitionTimestamp, partitionNameTxn);
                        ++this.partitionUpdated;
                    }
                    if (columnTop == this.tableWriter.getColumnTop(partitionTimestamp, columnIndex, -1L)) continue;
                    long partTs = this.tableWriter.getPartitionBy() != 3 ? partitionTimestamp : 0L;
                    this.columnVersionWriter.upsertColumnTop(partTs, columnIndex, columnTop > -1L ? columnTop : maxRow);
                    continue;
                }
                catch (Throwable th) {
                    LOG.error().$("error converting column [at=").$(this.tableWriter.getTableToken()).$(", column=").$safe(columnName).$(", from=").$(ColumnType.nameOf(existingType)).$(", to=").$(ColumnType.nameOf(newType)).$(", error=").$(th).I$();
                    this.asyncProcessingErrorCount.incrementAndGet();
                    this.consumeConversionTasks(this.messageBus.getColumnTaskQueue(), queueCount, false);
                    throw th;
                }
            }
            this.consumeConversionTasks(this.messageBus.getColumnTaskQueue(), queueCount, true);
            long elapsed = this.timer.getTicks() - start;
            LOG.info().$("completed column conversion [at=").$(this.tableWriter.getTableToken()).$(", column=").$safe(columnName).$(", from=").$(ColumnType.nameOf(existingType)).$(", to=").$(ColumnType.nameOf(newType)).$(", partitions=").$(this.partitionUpdated).$(", rows=").$(totalRows).$(", elapsed=").$(elapsed / 1000L).$("ms]").I$();
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cthConvertPartitionHandler(int existingType, int newType, long srcFixFd, long srcVarFd, long dstFixFd, long dstVarFd, long partitionTimestamp, long rowCount) {
        try {
            StaticSymbolTable symbolTable;
            boolean ok;
            if (this.asyncProcessingErrorCount.get() == 0 && !(ok = ColumnTypeConverter.convertColumn(0L, rowCount, existingType, srcFixFd, srcVarFd, symbolTable = ColumnType.isSymbol(existingType) ? this.symbolMapReader.newSymbolTableView() : null, newType, dstFixFd, dstVarFd, this.symbolMapper, this.ff, this.appendPageSize, this.noopConversionOffsetSink))) {
                LOG.critical().$("failed to convert column, column is corrupt [at=").$(this.tableWriter.getTableToken()).$(", column=").$safe(this.columnName).$(", from=").$(ColumnType.nameOf(existingType)).$(", to=").$(ColumnType.nameOf(newType)).$(", srcFixFd=").$(srcFixFd).$(", srcVarFd=").$(srcVarFd).$(", partition ").$ts(partitionTimestamp).I$();
                this.asyncProcessingErrorCount.incrementAndGet();
            }
        }
        catch (Throwable th) {
            this.asyncProcessingErrorCount.incrementAndGet();
            LogRecord log = LOG.critical().$("failed to convert column, column is corrupt [at=").$(this.tableWriter.getTableToken()).$(", column=").$safe(this.columnName).$(", from=").$(ColumnType.nameOf(existingType)).$(", to=").$(ColumnType.nameOf(newType)).$(", srcFixFd=").$(srcFixFd).$(", srcVarFd=").$(srcVarFd).$(", partition ").$ts(partitionTimestamp);
            if (th instanceof CairoException) {
                log.$(", errno=").$(((CairoException)th).getErrno());
            }
            log.$(", ex=").$(th).I$();
        }
        finally {
            this.closeFds(srcFixFd, srcVarFd, dstFixFd, dstVarFd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchConvertColumnPartitionTask(int existingType, int newType, long srcFixFd, long srcVarFd, long dstFixFd, long dstVarFd, long rowCount, long partitionTimestamp) {
        if (!ColumnType.isSymbol(newType)) {
            MPSequence pubSeq = this.messageBus.getColumnTaskPubSeq();
            RingQueue<ColumnTask> queue = this.messageBus.getColumnTaskQueue();
            long cursor = pubSeq.next();
            if (cursor > -1L) {
                try {
                    ColumnTask task = queue.get(cursor);
                    task.of(this.countDownLatch, existingType, newType, srcFixFd, srcVarFd, dstFixFd, dstVarFd, partitionTimestamp, rowCount, this.cthConvertPartitionHandler);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    pubSeq.done(cursor);
                }
            }
        }
        this.cthConvertPartitionHandler(existingType, newType, srcFixFd, srcVarFd, dstFixFd, dstVarFd, partitionTimestamp, rowCount);
        return false;
    }

    private void openColumnsRO(CharSequence name, long partitionTimestamp, int columnIndex, int columnType, int pathTrimToLen) {
        long columnNameTxn = this.tableWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
        if (ColumnType.isVarSize(columnType)) {
            this.fixedFd = TableUtils.openRO(this.ff, TableUtils.iFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), LOG);
            try {
                this.varFd = TableUtils.openRO(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), LOG);
            }
            catch (Throwable e) {
                this.ff.close(this.fixedFd);
                throw e;
            }
        } else {
            this.fixedFd = TableUtils.openRO(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), LOG);
            this.varFd = -1L;
        }
    }

    private void openColumnsRW(CharSequence name, long partitionTimestamp, int columnIndex, int columnType, int pathTrimToLen) {
        long columnNameTxn = this.tableWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
        if (ColumnType.isVarSize(columnType)) {
            this.fixedFd = TableUtils.openRW(this.ff, TableUtils.iFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), LOG, this.fileOpenOpts);
            try {
                this.varFd = TableUtils.openRW(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), LOG, this.fileOpenOpts);
            }
            catch (Throwable e) {
                this.ff.close(this.fixedFd);
                throw e;
            }
        } else {
            this.fixedFd = TableUtils.openRW(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), LOG, this.fileOpenOpts);
            this.varFd = -1L;
        }
    }

    private static class SymbolMapper
    implements SymbolMapWriterLite {
        private int columnIndex;
        private TableWriter tableWriter;

        private SymbolMapper() {
        }

        @Override
        public int resolveSymbol(CharSequence value) {
            return this.tableWriter.getSymbolIndexNoTransientCountUpdate(this.columnIndex, value);
        }

        void of(TableWriter tw, int columnIndex) {
            this.tableWriter = tw;
            this.columnIndex = columnIndex;
        }
    }
}

