/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8StringSink;
import org.jetbrains.annotations.Nullable;

public class Base64DecodeFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "from_base64(S)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function func = args.get(0);
        return new Base64DecodeFunc(func);
    }

    private static class Base64DecodeFunc
    extends BinFunction
    implements UnaryFunction {
        private final Function data;
        private final BinarySequenceUtf8Sink sink = new BinarySequenceUtf8Sink();

        public Base64DecodeFunc(Function data) {
            this.data = data;
        }

        @Override
        public Function getArg() {
            return this.data;
        }

        @Override
        public BinarySequence getBin(Record rec) {
            CharSequence str = this.data.getStrA(rec);
            if (str == null) {
                return null;
            }
            this.sink.clear();
            Chars.base64Decode(str, this.sink);
            return this.sink;
        }

        @Override
        public long getBinLen(Record rec) {
            BinarySequence bs = this.getBin(rec);
            if (bs == null) {
                return -1L;
            }
            return bs.length();
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("from_base64(").val(this.data).val(')');
        }

        private static class BinarySequenceUtf8Sink
        implements BinarySequence,
        Utf8Sink {
            private final Utf8StringSink sink = new Utf8StringSink();

            private BinarySequenceUtf8Sink() {
            }

            @Override
            public byte byteAt(long index) {
                return this.sink.byteAt((int)index);
            }

            public void clear() {
                this.sink.clear();
            }

            @Override
            public long length() {
                return this.sink.size();
            }

            @Override
            public Utf8Sink put(@Nullable Utf8Sequence us) {
                return this.sink.put(us);
            }

            @Override
            public Utf8Sink put(byte b) {
                return this.sink.putAny(b);
            }

            @Override
            public Utf8Sink putNonAscii(long lo, long hi) {
                return this.sink.putNonAscii(lo, hi);
            }
        }
    }
}

