/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class CastDoubleToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ds)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function doubleFunc = args.getQuick(0);
        if (doubleFunc.isConstant()) {
            StringSink sink = Misc.getThreadLocalSink();
            sink.put(doubleFunc.getDouble(null));
            return new StrConstant(Chars.toString(sink));
        }
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToStrFunction {
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public CharSequence getStrA(Record rec) {
            double value = this.arg.getDouble(rec);
            if (Numbers.isFinite(value)) {
                this.sinkA.clear();
                this.sinkA.put(value);
                return this.sinkA;
            }
            return null;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            double value = this.arg.getDouble(rec);
            if (Numbers.isNull(value)) {
                return null;
            }
            this.sinkB.clear();
            this.sinkB.put(value);
            return this.sinkB;
        }
    }
}

