/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToIPv4Function;
import io.questdb.griffin.engine.functions.constants.IPv4Constant;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;

public class CastVarcharToIPv4FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(\u00d8x)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            Utf8Sequence value = arg.getVarcharA(null);
            if (value == null || value.size() == 0) {
                return IPv4Constant.NULL;
            }
            try {
                int ip = Numbers.parseIPv4(value);
                return IPv4Constant.newInstance(ip);
            }
            catch (NumericException e) {
                throw SqlException.$(argPositions.getQuick(0), "invalid IPv4 constant");
            }
        }
        return new Func(arg);
    }

    private static class Func
    extends AbstractCastToIPv4Function {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public int getIPv4(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            return Numbers.parseIPv4Quiet(value != null ? value.asAsciiCharSequence() : null);
        }
    }
}

