/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SessionUserFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "session_user()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new SessionUserFunction();
    }

    static class SessionUserFunction
    extends StrFunction {
        private SecurityContext context;

        SessionUserFunction() {
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.context.getSessionPrincipal();
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.context.getSessionPrincipal();
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            this.context = executionContext.getSecurityContext();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(SessionUserFunctionFactory.SIGNATURE);
        }
    }
}

