/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicLong;

public class TxIDCurrentFunctionFactory
implements FunctionFactory {
    private static final AtomicLong PG_TX_ID = new AtomicLong();
    private static final String SIGNATURE = "txid_current()";

    public static long getTxID() {
        return PG_TX_ID.get();
    }

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new LongFunction(){

            @Override
            public long getLong(Record rec) {
                return PG_TX_ID.incrementAndGet();
            }

            @Override
            public void toPlan(PlanSink sink) {
                sink.val(TxIDCurrentFunctionFactory.SIGNATURE);
            }
        };
    }
}

