/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GeoIntFunction;

public class GeoIntColumn
extends GeoIntFunction {
    private static final GeoIntColumn[] COLUMNS;
    protected final int columnIndex;

    private GeoIntColumn(int columnIndex, int columnType) {
        super(columnType);
        this.columnIndex = columnIndex;
    }

    public static GeoIntColumn newInstance(int columnIndex, int columnType) {
        assert (ColumnType.getGeoHashBits(columnType) >= 16 && ColumnType.getGeoHashBits(columnType) <= 31);
        int bits = 16;
        if (columnIndex < 32) {
            return COLUMNS[columnIndex * 16 + ColumnType.getGeoHashBits(columnType) - 16];
        }
        return new GeoIntColumn(columnIndex, columnType);
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getGeoInt(Record rec) {
        return rec.getGeoInt(this.columnIndex);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    static {
        int bits = 16;
        COLUMNS = new GeoIntColumn[32 * bits];
        for (int col = 0; col < 32; ++col) {
            for (int bit = 16; bit <= 31; ++bit) {
                GeoIntColumn.COLUMNS[col * bits + bit - 16] = new GeoIntColumn(col, ColumnType.getGeoHashTypeWithBits(bit));
            }
        }
    }
}

