/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import org.jetbrains.annotations.Nullable;

public class EqSymLongFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(KL)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function fn0 = args.getQuick(0);
        Function longFn = args.getQuick(1);
        if (ColumnType.isNull(fn0.getType())) {
            if (longFn.isConstant()) {
                return longFn.getLong(null) == Long.MIN_VALUE ? BooleanConstant.TRUE : BooleanConstant.FALSE;
            }
            return new EqLongNullFunction(longFn);
        }
        SymbolFunction symFn = (SymbolFunction)fn0;
        if (longFn.isConstant()) {
            String constValue;
            long val = longFn.getLong(null);
            String string = constValue = val != Long.MIN_VALUE ? ((Utf16Sink)Misc.getThreadLocalSink().put(val)).toString() : null;
            if (symFn.getStaticSymbolTable() != null) {
                return new ConstValueStaticSymbolTableFunction(symFn, constValue);
            }
            return new ConstValueDynamicSymbolTableFunction(symFn, constValue);
        }
        return new VariableValueFunction(symFn, longFn);
    }

    private static class EqLongNullFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function longFn;

        public EqLongNullFunction(Function longFn) {
            this.longFn = longFn;
        }

        @Override
        public Function getArg() {
            return this.longFn;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated == (this.longFn.getLong(rec) != Long.MIN_VALUE);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.longFn);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("=").val("null");
        }
    }

    private static class ConstValueStaticSymbolTableFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final SymbolFunction arg;
        private final String constant;
        private int valueIndex;

        public ConstValueStaticSymbolTableFunction(SymbolFunction arg, @Nullable String constant) {
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getInt(rec) == this.valueIndex);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.arg.init(symbolTableSource, executionContext);
            StaticSymbolTable symbolTable = this.arg.getStaticSymbolTable();
            assert (symbolTable != null);
            this.valueIndex = symbolTable.keyOf(this.constant);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").val(this.constant).val('\'');
        }
    }

    private static class ConstValueDynamicSymbolTableFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final String constant;

        public ConstValueDynamicSymbolTableFunction(Function arg, @Nullable String constant) {
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Chars.equalsNullable(this.arg.getSymbol(rec), this.constant);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").val(this.constant).val('\'');
        }
    }

    private static class VariableValueFunction
    extends AbstractEqBinaryFunction {
        private final StringSink sink = new StringSink();

        public VariableValueFunction(Function symFn, Function longFn) {
            super(symFn, longFn);
        }

        @Override
        public boolean getBool(Record rec) {
            long value = this.right.getLong(rec);
            if (value != Long.MIN_VALUE) {
                this.sink.clear();
                this.sink.put(value);
                return this.negated != Chars.equalsNc((CharSequence)this.sink, this.left.getSymbol(rec));
            }
            return this.negated == (this.left.getSymbol(rec) != null);
        }
    }
}

