/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class AvgDoubleGroupByFunction
extends DoubleFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public AvgDoubleGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        double d = this.arg.getDouble(record);
        if (Numbers.isFinite(d)) {
            mapValue.putDouble(this.valueIndex, d);
            mapValue.putLong(this.valueIndex + 1, 1L);
        } else {
            mapValue.putDouble(this.valueIndex, 0.0);
            mapValue.putLong(this.valueIndex + 1, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        double d = this.arg.getDouble(record);
        if (Numbers.isFinite(d)) {
            mapValue.addDouble(this.valueIndex, d);
            mapValue.addLong(this.valueIndex + 1, 1L);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public double getDouble(Record rec) {
        return rec.getDouble(this.valueIndex) / (double)rec.getLong(this.valueIndex + 1);
    }

    @Override
    public String getName() {
        return "avg";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
        columnTypes.add(6);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        double srcSum = srcValue.getDouble(this.valueIndex);
        long srcCount = srcValue.getLong(this.valueIndex + 1);
        double destSum = destValue.getDouble(this.valueIndex);
        long destCount = destValue.getLong(this.valueIndex + 1);
        destValue.putDouble(this.valueIndex, destSum + srcSum);
        destValue.putLong(this.valueIndex + 1, destCount + srcCount);
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
        mapValue.putLong(this.valueIndex + 1, 1L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
        mapValue.putLong(this.valueIndex + 1, 0L);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

