/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class LtTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(NN)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0), args.getQuick(1));
    }

    private static class Func
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function leftFunc;
        private final Function rightFunc;

        public Func(Function leftFunc, Function rightFunc) {
            this.leftFunc = leftFunc;
            this.rightFunc = rightFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            return Numbers.lessThan(this.leftFunc.getTimestamp(rec), this.rightFunc.getTimestamp(rec), this.negated);
        }

        @Override
        public Function getLeft() {
            return this.leftFunc;
        }

        @Override
        public Function getRight() {
            return this.rightFunc;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.leftFunc);
            if (this.negated) {
                sink.val(">=");
            } else {
                sink.val('<');
            }
            sink.val(this.rightFunc);
        }
    }
}

