/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.lt.LtStrVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.lt.LtVarcharStrFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;

public class LtVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(\u00d8\u00d8)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function a = args.getQuick(0);
        Function b = args.getQuick(1);
        if (a.isConstant() && !b.isConstant()) {
            Utf8Sequence constValue = a.getVarcharA(null);
            if (constValue == null) {
                return BooleanConstant.FALSE;
            }
            return new LtStrVarcharFunctionFactory.ConstOnLeftFunc(constValue, b);
        }
        if (!a.isConstant() && b.isConstant()) {
            Utf8Sequence constValue = b.getVarcharA(null);
            if (constValue == null) {
                return BooleanConstant.FALSE;
            }
            return new LtVarcharStrFunctionFactory.ConstOnRightFunc(a, constValue);
        }
        return new Func(a, b);
    }

    static class Func
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public Func(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            return Utf8s.lessThan(this.left.getVarcharA(rec), this.right.getVarcharB(rec), this.negated);
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public String getName() {
            if (this.negated) {
                return ">=";
            }
            return "<";
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            sink.val(this.getName());
            sink.val(this.right);
        }
    }
}

