/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class Atan2DoubleFunctionFactory
implements FunctionFactory {
    public static final String SYMBOL = "atan2";

    @Override
    public String getSignature() {
        return "atan2(DD)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Atan2Function(args.getQuick(0), args.getQuick(1));
    }

    private static class Atan2Function
    extends DoubleFunction
    implements Function {
        final Function x;
        final Function y;

        public Atan2Function(Function y, Function x) {
            this.y = y;
            this.x = x;
        }

        @Override
        public double getDouble(Record rec) {
            return Math.atan2(this.y.getDouble(rec), this.x.getDouble(rec));
        }

        @Override
        public String getName() {
            return Atan2DoubleFunctionFactory.SYMBOL;
        }
    }
}

