/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.FunctionExtension;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntervalFunction;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import org.jetbrains.annotations.NotNull;

public class RndIntervalFunctionFactory
implements FunctionFactory {
    private static final long LO_BOUNDARY = 1999999000000000L;
    private static final long MAX_RANGE = 199999000000000L;

    @Override
    public String getSignature() {
        return "rnd_interval()";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new RndFunction();
    }

    private static class RndFunction
    extends IntervalFunction
    implements Function,
    FunctionExtension {
        private final Interval interval = new Interval();
        private Rnd rnd;

        private RndFunction() {
        }

        @Override
        public FunctionExtension extendedOps() {
            return this;
        }

        @Override
        public int getArrayLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Interval getInterval(Record rec) {
            long lo = this.rnd.nextLong(1999999000000000L);
            long range = this.rnd.nextLong(199999000000000L);
            return this.interval.of(lo, lo + range);
        }

        @Override
        public String getName() {
            return "rnd_interval";
        }

        @Override
        public Record getRecord(Record rec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence getStrA(Record rec, int arrayIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence getStrB(Record rec, int arrayIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getStrLen(Record rec, int arrayIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isRandom() {
            return true;
        }
    }
}

