/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class StartsWithStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "starts_with(SS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function strFunc = args.get(0);
        Function prefixFunc = args.get(1);
        return new StartsWithStrFunction(strFunc, prefixFunc);
    }

    private static class StartsWithStrFunction
    extends BooleanFunction
    implements BinaryFunction {
        private final Function prefixFunc;
        private final Function strFunc;

        public StartsWithStrFunction(Function strFunc, Function prefixFunc) {
            this.strFunc = strFunc;
            this.prefixFunc = prefixFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence str = this.strFunc.getStrA(rec);
            CharSequence prefix = this.prefixFunc.getStrA(rec);
            if (str == null || prefix == null) {
                return false;
            }
            return Chars.startsWith(str, prefix);
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public String getName() {
            return "starts_with";
        }

        @Override
        public Function getRight() {
            return this.prefixFunc;
        }
    }
}

