/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.VirtualRecordNoRowid;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.GroupByAllocatorFactory;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdaterFactory;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class GroupByNotKeyedRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final GroupByNotKeyedRecordCursor cursor;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final SimpleMapValue simpleMapValue;
    private final VirtualRecord virtualRecordA;

    public GroupByNotKeyedRecordCursorFactory(@NotNull BytecodeAssembler asm, CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, int valueCount) {
        super(groupByMetadata);
        try {
            this.simpleMapValue = new SimpleMapValue(valueCount);
            this.base = base;
            this.groupByFunctions = groupByFunctions;
            this.virtualRecordA = new VirtualRecordNoRowid(groupByFunctions);
            this.virtualRecordA.of(this.simpleMapValue);
            GroupByFunctionsUpdater updater = GroupByFunctionsUpdaterFactory.getInstance(asm, groupByFunctions);
            boolean earlyExitSupported = GroupByUtils.isEarlyExitSupported(groupByFunctions);
            this.cursor = earlyExitSupported ? new EarlyExitGroupByNotKeyedRecordCursor(configuration, groupByFunctions, updater) : new GroupByNotKeyedRecordCursor(configuration, groupByFunctions, updater);
        }
        catch (Throwable e) {
            Misc.freeObjList(groupByFunctions);
            throw e;
        }
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            return this.cursor.of(baseCursor, executionContext);
        }
        catch (Throwable e) {
            Misc.free(baseCursor);
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("GroupBy");
        sink.meta("vectorized").val(false);
        sink.optAttr((CharSequence)"values", this.groupByFunctions, true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.groupByFunctions);
        Misc.free(this.base);
    }

    private class EarlyExitGroupByNotKeyedRecordCursor
    extends GroupByNotKeyedRecordCursor {
        public EarlyExitGroupByNotKeyedRecordCursor(CairoConfiguration configuration, ObjList<GroupByFunction> groupByFunctions, GroupByFunctionsUpdater groupByFunctionsUpdater) {
            super(configuration, groupByFunctions, groupByFunctionsUpdater);
        }

        @Override
        public boolean earlyExit() {
            boolean earlyExit = true;
            int n = GroupByNotKeyedRecordCursorFactory.this.groupByFunctions.size();
            for (int i = 0; i < n; ++i) {
                earlyExit &= GroupByNotKeyedRecordCursorFactory.this.groupByFunctions.getQuick(i).earlyExit(GroupByNotKeyedRecordCursorFactory.this.simpleMapValue);
            }
            return earlyExit;
        }
    }

    private class GroupByNotKeyedRecordCursor
    implements NoRandomAccessRecordCursor {
        private static final int INIT_DONE = 2;
        private static final int INIT_FIRST_RECORD_DONE = 1;
        private static final int INIT_PENDING = 0;
        private final GroupByAllocator allocator;
        private final GroupByFunctionsUpdater groupByFunctionsUpdater;
        private RecordCursor baseCursor;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private int initState;
        private int recordsRemaining = 1;
        private long rowId;

        public GroupByNotKeyedRecordCursor(CairoConfiguration configuration, ObjList<GroupByFunction> groupByFunctions, GroupByFunctionsUpdater groupByFunctionsUpdater) {
            this.groupByFunctionsUpdater = groupByFunctionsUpdater;
            this.allocator = GroupByAllocatorFactory.createAllocator(configuration);
            GroupByUtils.setAllocator(groupByFunctions, this.allocator);
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            if (this.recordsRemaining > 0) {
                counter.add(this.recordsRemaining);
                this.recordsRemaining = 0;
            }
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
            Misc.free(this.allocator);
            Misc.clearObjList(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions);
        }

        public boolean earlyExit() {
            return false;
        }

        @Override
        public Record getRecord() {
            return GroupByNotKeyedRecordCursorFactory.this.virtualRecordA;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return (SymbolTable)((Object)GroupByNotKeyedRecordCursorFactory.this.groupByFunctions.getQuick(columnIndex));
        }

        @Override
        public boolean hasNext() {
            if (this.initState != 2) {
                Record baseRecord = this.baseCursor.getRecord();
                if (this.initState != 1) {
                    if (this.baseCursor.hasNext()) {
                        this.groupByFunctionsUpdater.updateNew(GroupByNotKeyedRecordCursorFactory.this.simpleMapValue, baseRecord, this.rowId++);
                    } else {
                        this.groupByFunctionsUpdater.updateEmpty(GroupByNotKeyedRecordCursorFactory.this.simpleMapValue);
                    }
                    this.initState = 1;
                }
                while (this.baseCursor.hasNext()) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    this.groupByFunctionsUpdater.updateExisting(GroupByNotKeyedRecordCursorFactory.this.simpleMapValue, baseRecord, this.rowId++);
                    if (!this.earlyExit()) continue;
                }
                this.toTop();
                this.initState = 2;
            }
            return this.recordsRemaining-- > 0;
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return ((SymbolFunction)((Object)GroupByNotKeyedRecordCursorFactory.this.groupByFunctions.getQuick(columnIndex))).newSymbolTable();
        }

        public RecordCursor of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
            this.baseCursor = baseCursor;
            this.circuitBreaker = executionContext.getCircuitBreaker();
            this.initState = 0;
            Function.init(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions, baseCursor, executionContext, null);
            this.toTop();
            return this;
        }

        @Override
        public long preComputedStateSize() {
            return this.initState;
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void toTop() {
            this.rowId = 0L;
            this.recordsRemaining = 1;
            GroupByUtils.toTop(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions);
        }
    }
}

