/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractAsOfJoinFastRecordCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.std.Misc;

public class AsOfJoinNoKeyFastRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final AsOfJoinFastRecordCursor cursor;

    public AsOfJoinNoKeyFastRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int columnSplit, long toleranceInterval) {
        super(metadata, null, masterFactory, slaveFactory);
        assert (slaveFactory.supportsTimeFrameCursor());
        this.cursor = new AsOfJoinFastRecordCursor(columnSplit, NullRecordFactory.getInstance(slaveFactory.getMetadata()), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex(), configuration.getSqlAsOfJoinLookAhead(), toleranceInterval);
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        TimeFrameRecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getTimeFrameCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("AsOf Join Fast Scan");
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
    }

    private static class AsOfJoinFastRecordCursor
    extends AbstractAsOfJoinFastRecordCursor {
        private final long toleranceInterval;
        private long slaveTimestamp = Long.MIN_VALUE;

        public AsOfJoinFastRecordCursor(int columnSplit, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex, int lookahead, long toleranceInterval) {
            super(columnSplit, nullRecord, masterTimestampIndex, slaveTimestampIndex, lookahead);
            this.toleranceInterval = toleranceInterval;
        }

        @Override
        public boolean hasNext() {
            if (this.isMasterHasNextPending) {
                this.masterHasNext = this.masterCursor.hasNext();
                this.isMasterHasNextPending = false;
            }
            if (this.masterHasNext) {
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                if (masterTimestamp < this.lookaheadTimestamp) {
                    if (this.toleranceInterval != Long.MIN_VALUE && this.slaveTimestamp < masterTimestamp - this.toleranceInterval) {
                        this.record.hasSlave(false);
                    }
                    this.isMasterHasNextPending = true;
                    return true;
                }
                this.nextSlave(masterTimestamp);
                if (this.toleranceInterval != Long.MIN_VALUE && this.record.hasSlave()) {
                    this.slaveTimestamp = this.slaveRecB.getTimestamp(this.slaveTimestampIndex);
                    this.record.hasSlave(this.slaveTimestamp >= masterTimestamp - this.toleranceInterval);
                }
                this.isMasterHasNextPending = true;
                return true;
            }
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.slaveTimestamp = Long.MIN_VALUE;
        }
    }
}

