/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.PageFrameAddressCache;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.engine.table.PageFrameRecordCursor;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPageFrameRecordCursor
implements PageFrameRecordCursor {
    protected final PageFrameAddressCache frameAddressCache;
    protected final PageFrameMemoryPool frameMemoryPool;
    protected final PageFrameMemoryRecord recordA;
    protected final PageFrameMemoryRecord recordB;
    private final RecordMetadata metadata;
    protected int frameCount = 0;
    protected PageFrameCursor frameCursor;

    public AbstractPageFrameRecordCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata) {
        this.metadata = metadata;
        this.recordA = new PageFrameMemoryRecord(0);
        this.recordB = new PageFrameMemoryRecord(1);
        this.frameAddressCache = new PageFrameAddressCache(configuration);
        this.frameMemoryPool = new PageFrameMemoryPool(configuration.getSqlParquetFrameCacheCapacity());
    }

    @Override
    public void close() {
        Misc.free(this.frameMemoryPool);
        Misc.free(this.recordA);
        Misc.free(this.recordB);
        this.frameCursor = Misc.free(this.frameCursor);
    }

    @Override
    public PageFrameCursor getPageFrameCursor() {
        return this.frameCursor;
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        return this.recordB;
    }

    @Override
    public StaticSymbolTable getSymbolTable(int columnIndex) {
        return this.frameCursor.getSymbolTable(columnIndex);
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.frameCursor.newSymbolTable(columnIndex);
    }

    @Override
    public void recordAt(Record record, long rowId) {
        PageFrameMemoryRecord frameMemoryRecord = (PageFrameMemoryRecord)record;
        this.frameMemoryPool.navigateTo(Rows.toPartitionIndex(rowId), frameMemoryRecord);
        frameMemoryRecord.setRowIndex(Rows.toLocalRowID(rowId));
    }

    @Override
    public void toTop() {
        this.frameCount = 0;
        this.frameCursor.toTop();
    }

    protected void init() {
        this.frameAddressCache.of(this.metadata, this.frameCursor.getColumnIndexes());
        this.frameMemoryPool.of(this.frameAddressCache);
        this.frameCount = 0;
        this.frameCursor.toTop();
    }
}

