/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.BwdTableReaderPageFrameCursor;
import io.questdb.griffin.engine.table.FwdTableReaderPageFrameCursor;
import io.questdb.griffin.engine.table.TablePageFrameCursor;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

abstract class AbstractPageFrameRecordCursorFactory
extends AbstractRecordCursorFactory {
    protected final IntList columnIndexes;
    protected final IntList columnSizeShifts;
    protected final int pageFrameMaxRows;
    protected final int pageFrameMinRows;
    protected final PartitionFrameCursorFactory partitionFrameCursorFactory;
    protected TablePageFrameCursor pageFrameCursor;

    public AbstractPageFrameRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(metadata);
        this.partitionFrameCursorFactory = partitionFrameCursorFactory;
        this.columnIndexes = columnIndexes;
        this.columnSizeShifts = columnSizeShifts;
        this.pageFrameMinRows = configuration.getSqlPageFrameMinRows();
        this.pageFrameMaxRows = configuration.getSqlPageFrameMaxRows();
    }

    @Override
    public String getBaseColumnName(int columnIndex) {
        return this.partitionFrameCursorFactory.getMetadata().getColumnName(this.columnIndexes.getQuick(columnIndex));
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        TablePageFrameCursor frameCursor = this.initPageFrameCursor(executionContext);
        try {
            return this.initRecordCursor(frameCursor, executionContext);
        }
        catch (Throwable e) {
            frameCursor.close();
            throw e;
        }
    }

    @Override
    public TableToken getTableToken() {
        return this.partitionFrameCursorFactory.getTableToken();
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.partitionFrameCursorFactory.supportsTableRowId(tableToken);
    }

    @Override
    protected void _close() {
        Misc.free(this.pageFrameCursor);
        Misc.free(this.partitionFrameCursorFactory);
    }

    protected TablePageFrameCursor initPageFrameCursor(SqlExecutionContext executionContext) throws SqlException {
        int order = this.partitionFrameCursorFactory.getOrder();
        PartitionFrameCursor partitionFrameCursor = this.partitionFrameCursorFactory.getCursor(executionContext, 2);
        if (this.pageFrameCursor == null) {
            this.pageFrameCursor = order == 0 || order == 2 ? new FwdTableReaderPageFrameCursor(this.columnIndexes, this.columnSizeShifts, 1, this.pageFrameMinRows, this.pageFrameMaxRows) : new BwdTableReaderPageFrameCursor(this.columnIndexes, this.columnSizeShifts, 1, this.pageFrameMinRows, this.pageFrameMaxRows);
        }
        return this.pageFrameCursor.of(partitionFrameCursor);
    }

    protected abstract RecordCursor initRecordCursor(PageFrameCursor var1, SqlExecutionContext var2) throws SqlException;
}

