/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.table.AsyncGroupByNotKeyedAtom;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Os;

class AsyncGroupByNotKeyedRecordCursor
implements NoRandomAccessRecordCursor {
    private static final Log LOG = LogFactory.getLog(AsyncGroupByNotKeyedRecordCursor.class);
    private final ObjList<GroupByFunction> groupByFunctions;
    private final VirtualRecord recordA;
    private int frameLimit;
    private PageFrameSequence<AsyncGroupByNotKeyedAtom> frameSequence;
    private boolean isOpen;
    private boolean isValueBuilt;
    private int recordsRemaining = 1;

    public AsyncGroupByNotKeyedRecordCursor(ObjList<GroupByFunction> groupByFunctions) {
        this.groupByFunctions = groupByFunctions;
        this.recordA = new VirtualRecord(groupByFunctions);
        this.isOpen = true;
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        if (this.recordsRemaining > 0) {
            counter.add(this.recordsRemaining);
            this.recordsRemaining = 0;
        }
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            Misc.clearObjList(this.groupByFunctions);
            if (this.frameSequence != null) {
                LOG.debug().$("closing [shard=").$(this.frameSequence.getShard()).$(", frameCount=").$(this.frameLimit).I$();
                if (this.frameLimit > -1) {
                    this.frameSequence.await();
                }
                this.frameSequence.clear();
            }
        }
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return (SymbolTable)((Object)this.groupByFunctions.getQuick(columnIndex));
    }

    @Override
    public boolean hasNext() {
        if (!this.isValueBuilt) {
            this.buildValue();
        }
        return this.recordsRemaining-- > 0;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return ((SymbolFunction)((Object)this.groupByFunctions.getQuick(columnIndex))).newSymbolTable();
    }

    @Override
    public long preComputedStateSize() {
        return RecordCursor.fromBool(this.isValueBuilt);
    }

    @Override
    public long size() {
        return 1L;
    }

    @Override
    public void toTop() {
        this.recordsRemaining = 1;
        GroupByUtils.toTop(this.groupByFunctions);
        if (this.frameSequence != null) {
            this.frameSequence.getAtom().toTop();
        }
    }

    private void buildValue() {
        if (this.frameLimit == -1) {
            this.frameSequence.prepareForDispatch();
            this.frameLimit = this.frameSequence.getFrameCount() - 1;
        }
        int frameIndex = -1;
        boolean allFramesActive = true;
        try {
            do {
                long cursor;
                if ((cursor = this.frameSequence.next()) > -1L) {
                    PageFrameReduceTask task = this.frameSequence.getTask(cursor);
                    LOG.debug().$("collected [shard=").$(this.frameSequence.getShard()).$(", frameIndex=").$(task.getFrameIndex()).$(", frameCount=").$(this.frameSequence.getFrameCount()).$(", active=").$(this.frameSequence.isActive()).$(", cursor=").$(cursor).I$();
                    if (task.hasError()) {
                        throw CairoException.nonCritical().position(task.getErrorMessagePosition()).put(task.getErrorMsg()).setCancellation(task.isCancelled()).setInterruption(task.isCancelled()).setOutOfMemory(task.isOutOfMemory());
                    }
                    allFramesActive &= this.frameSequence.isActive();
                    frameIndex = task.getFrameIndex();
                    this.frameSequence.collect(cursor, false);
                    continue;
                }
                if (cursor == -2L) break;
                Os.pause();
            } while (frameIndex < this.frameLimit);
        }
        catch (Throwable e) {
            LOG.error().$("group by error [ex=").$(e).I$();
            if (e instanceof CairoException) {
                CairoException ce = (CairoException)e;
                if (ce.isInterruption()) {
                    this.throwTimeoutException();
                } else {
                    throw ce;
                }
            }
            throw CairoException.nonCritical().put(e.getMessage());
        }
        if (!allFramesActive) {
            this.throwTimeoutException();
        }
        AsyncGroupByNotKeyedAtom atom = this.frameSequence.getAtom();
        GroupByFunctionsUpdater functionUpdater = atom.getFunctionUpdater(-1);
        SimpleMapValue destValue = atom.getOwnerMapValue();
        int n = atom.getPerWorkerMapValues().size();
        for (int i = 0; i < n; ++i) {
            SimpleMapValue srcValue = atom.getPerWorkerMapValues().getQuick(i);
            if (srcValue.isNew()) continue;
            if (destValue.isNew()) {
                destValue.copy(srcValue);
            } else {
                functionUpdater.merge(destValue, srcValue);
            }
            destValue.setNew(false);
        }
        this.isValueBuilt = true;
    }

    private void throwTimeoutException() {
        if (this.frameSequence.getCancelReason() == 3) {
            throw CairoException.queryCancelled();
        }
        throw CairoException.queryTimedOut();
    }

    void of(PageFrameSequence<AsyncGroupByNotKeyedAtom> frameSequence, SqlExecutionContext executionContext) throws SqlException {
        if (!this.isOpen) {
            this.isOpen = true;
        }
        this.frameSequence = frameSequence;
        AsyncGroupByNotKeyedAtom atom = frameSequence.getAtom();
        this.recordA.of(atom.getOwnerMapValue());
        Function.init(this.groupByFunctions, frameSequence.getSymbolTableSource(), executionContext, null);
        this.isValueBuilt = false;
        this.frameLimit = -1;
        this.toTop();
    }
}

