/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.ParanoiaState;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecordUtf8Sink;
import io.questdb.log.LogWriter;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Files;
import io.questdb.std.Os;
import io.questdb.std.str.Utf8StringSink;
import java.io.Closeable;
import java.util.Arrays;

public class LogConsoleWriter
extends SynchronizedJob
implements Closeable,
LogWriter {
    private static final int DEBUG_LOG_HISTORY_LENGTH = 25;
    private final long fd = Files.getStdOutFdInternal();
    private final int level;
    private final LogHistory logHistory;
    private final RingQueue<LogRecordUtf8Sink> ring;
    private final SCSequence subSeq;
    private LogInterceptor interceptor;
    private final QueueConsumer<LogRecordUtf8Sink> myConsumer = this::toStdOut;

    public LogConsoleWriter(RingQueue<LogRecordUtf8Sink> ring, SCSequence subSeq, int level) {
        this.ring = ring;
        this.subSeq = subSeq;
        this.level = level;
        if (ParanoiaState.LOG_PARANOIA_MODE == 1) {
            System.out.println("BASIC LOG PARANOIA MODE ACTIVE");
            this.logHistory = null;
        } else if (ParanoiaState.LOG_PARANOIA_MODE == 2) {
            System.out.println("AGGRESSIVE LOG PARANOIA MODE ACTIVE");
            this.logHistory = new LogHistory();
        } else {
            this.logHistory = null;
        }
    }

    @Override
    public void bindProperties(LogFactory factory) {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean runSerially() {
        return this.subSeq.consumeAll(this.ring, this.myConsumer);
    }

    public void setInterceptor(LogInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    private void toStdOut(LogRecordUtf8Sink sink) {
        try {
            if ((sink.getLevel() & this.level) != 0) {
                if (this.interceptor != null) {
                    this.interceptor.onLog(sink);
                }
                if (ParanoiaState.LOG_PARANOIA_MODE != 0) {
                    this.toStdOutWithErrorDetection(sink);
                } else {
                    Files.append(this.fd, sink.ptr(), (long)sink.size());
                }
            }
        }
        catch (Throwable th) {
            System.out.println("Exception while writing a log line");
            th.printStackTrace(System.out);
        }
    }

    private void toStdOutWithErrorDetection(LogRecordUtf8Sink sink) {
        if (this.logHistory != null) {
            this.logHistory.addLine(sink);
        }
        int sinkSize = sink.size();
        long res = Files.append(this.fd, sink.ptr(), (long)sinkSize);
        if (res == (long)sinkSize) {
            return;
        }
        String errMsg = "#$#$ LOGGING ERROR: Files.append() returned " + res + ", expected result was " + sinkSize + ". Os.errno() " + Os.errno() + ", fd " + Files.toOsFd(this.fd) + ".";
        if (this.logHistory != null) {
            System.out.println(errMsg + " Recent lines logged (up to 25):");
            this.logHistory.print();
        } else {
            System.out.println(errMsg + " To debug this issue, set LogConsoleWriter.DEBUG_CLOSED_STDOUT to true.");
        }
        System.out.println("#$#$ END OF LOGGING ERROR REPORT");
    }

    private static class LogHistory {
        private final Utf8StringSink[] logLineArray = new Utf8StringSink[25];
        private long arrayPos = 0L;

        LogHistory() {
            Arrays.setAll(this.logLineArray, i -> new Utf8StringSink(512));
        }

        void addLine(LogRecordUtf8Sink sink) {
            Utf8StringSink debugSink = this.logLineArray[(int)(this.arrayPos++ % (long)this.logLineArray.length)];
            debugSink.clear();
            debugSink.put(sink);
        }

        void print() {
            for (int i = 0; i < this.logLineArray.length; ++i) {
                Utf8StringSink sink = this.logLineArray[(int)((this.arrayPos + (long)i) % (long)this.logLineArray.length)];
                if (sink.size() == 0) continue;
                System.out.print(sink);
                sink.clear();
            }
        }
    }

    @FunctionalInterface
    public static interface LogInterceptor {
        public void onLog(LogRecordUtf8Sink var1);
    }
}

