/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.ConcurrentSegmentManipulator;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Os;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class ConcurrentQueueSegment<T> {
    private static final AtomicLongFieldUpdater<PaddedHeadAndTail> HEAD = AtomicLongFieldUpdater.newUpdater(PaddedHeadAndTail.class, "head");
    private static final AtomicLongFieldUpdater<PaddedHeadAndTail> TAIL = AtomicLongFieldUpdater.newUpdater(PaddedHeadAndTail.class, "tail");
    private final ObjectFactory<T> factory;
    private final int freezeOffset;
    private final PaddedHeadAndTail headAndTail = new PaddedHeadAndTail();
    private final ConcurrentSegmentManipulator<T> queueManipulator;
    private final Slot<T>[] slots;
    private final long slotsMask;
    volatile boolean frozenForEnqueues;
    ConcurrentQueueSegment<T> nextSegment;

    ConcurrentQueueSegment(ObjectFactory<T> factory, ConcurrentSegmentManipulator<T> queueManipulator, int boundedLength) {
        this.queueManipulator = queueManipulator;
        this.slots = new Slot[boundedLength];
        this.slotsMask = boundedLength - 1;
        this.freezeOffset = this.slots.length * 2;
        this.factory = factory;
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = new Slot();
            this.slots[i].item = this.createSlotItem();
            this.slots[i].sequenceNumber = i;
        }
    }

    public int getCapacity() {
        return this.slots.length;
    }

    public T tryDequeue(T target) {
        Slot<T>[] slots = this.slots;
        while (true) {
            long currentHead = this.headAndTail.head;
            int slotsIndex = (int)(currentHead & this.slotsMask);
            long sequenceNumber = slots[slotsIndex].sequenceNumber;
            long diff = sequenceNumber - (currentHead + 1L);
            if (diff == 0L) {
                if (!HEAD.compareAndSet(this.headAndTail, currentHead, currentHead + 1L)) continue;
                T val = this.queueManipulator.dequeue(slots, slotsIndex, target);
                slots[slotsIndex].sequenceNumber = currentHead + (long)slots.length;
                return val;
            }
            if (diff >= 0L) continue;
            boolean frozen = this.frozenForEnqueues;
            long currentTail = this.headAndTail.tail;
            if (currentTail - currentHead <= 0L || frozen && currentTail - (long)this.freezeOffset - currentHead <= 0L) {
                return null;
            }
            Os.pause();
        }
    }

    public boolean tryEnqueue(T item) {
        Slot<T>[] slots = this.slots;
        while (true) {
            long currentTail = this.headAndTail.tail;
            int slotsIndex = (int)(currentTail & this.slotsMask);
            long sequenceNumber = slots[slotsIndex].sequenceNumber;
            long diff = sequenceNumber - currentTail;
            if (diff == 0L) {
                if (!TAIL.compareAndSet(this.headAndTail, currentTail, currentTail + 1L)) continue;
                this.queueManipulator.enqueue(item, slots, slotsIndex);
                slots[slotsIndex].sequenceNumber = currentTail + 1L;
                return true;
            }
            if (diff < 0L) break;
        }
        return false;
    }

    private T createSlotItem() {
        return this.factory.newInstance();
    }

    void ensureFrozenForEnqueues() {
        if (!this.frozenForEnqueues) {
            this.frozenForEnqueues = true;
            TAIL.addAndGet(this.headAndTail, this.freezeOffset);
        }
    }

    private static class PaddedHeadAndTail {
        public volatile long head;
        public long head1;
        public long head2;
        public long head3;
        public long head4;
        public long head5;
        public long head6;
        public long head7;
        public volatile long tail;
        public long tail1;
        public long tail2;
        public long tail3;
        public long tail4;
        public long tail5;
        public long tail6;
        public long tail7;

        private PaddedHeadAndTail() {
        }
    }

    public static class Slot<T> {
        public T item;
        public volatile long sequenceNumber;
    }
}

