/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.DirectLongLongSortedList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class DirectLongLongDescList
implements DirectLongLongSortedList {
    private final int capacity;
    private final Cursor cursor = new Cursor();
    private final int memoryTag;
    private long ptr;
    private int size;

    public DirectLongLongDescList(int capacity, int memoryTag) {
        this.capacity = capacity;
        this.memoryTag = memoryTag;
        this.ptr = Unsafe.malloc(16L * (long)capacity, memoryTag);
        this.size = 0;
    }

    @Override
    public void add(long index, long value) {
        if (this.size == this.capacity && Unsafe.getUnsafe().getLong(this.ptr + 16L * (long)(this.size - 1)) >= value) {
            return;
        }
        int p = this.binSearch(value);
        if (p < this.capacity - 1) {
            Vect.memmove(this.ptr + 16L * (long)(p + 1), this.ptr + 16L * (long)p, 16L * (long)(this.capacity - p - 1));
        }
        Unsafe.getUnsafe().putLong(this.ptr + 16L * (long)p, value);
        Unsafe.getUnsafe().putLong(this.ptr + 16L * (long)p + 8L, index);
        this.size = Math.min(this.capacity, this.size + 1);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.cursor.toTop();
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            this.ptr = Unsafe.free(this.ptr, 16L * (long)this.capacity, this.memoryTag);
            this.size = 0;
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public void reopen() {
        if (this.ptr == 0L) {
            this.ptr = Unsafe.malloc(16L * (long)this.capacity, this.memoryTag);
        }
        this.clear();
    }

    @Override
    public int size() {
        return this.size;
    }

    private int binSearch(long v) {
        int low = 0;
        int high = this.size;
        while (high - low > 65) {
            int mid = low + high - 1 >>> 1;
            long midVal = Unsafe.getUnsafe().getLong(this.ptr + 16L * (long)mid);
            if (midVal > v) {
                low = mid + 1;
                continue;
            }
            if (midVal < v) {
                high = mid;
                continue;
            }
            while (++mid < high && Unsafe.getUnsafe().getLong(this.ptr + 16L * (long)mid) == v) {
            }
            return mid;
        }
        return this.scanSearch(v, low);
    }

    private int scanSearch(long v, int low) {
        for (int i = low; i < this.size; ++i) {
            if (Unsafe.getUnsafe().getLong(this.ptr + 16L * (long)i) >= v) continue;
            return i;
        }
        return this.size;
    }

    public class Cursor
    implements DirectLongLongSortedList.Cursor {
        private int pos = -1;

        @Override
        public boolean hasNext() {
            return ++this.pos < DirectLongLongDescList.this.size;
        }

        @Override
        public long index() {
            return Unsafe.getUnsafe().getLong(DirectLongLongDescList.this.ptr + 16L * (long)this.pos + 8L);
        }

        @Override
        public void toTop() {
            this.pos = -1;
        }

        @Override
        public long value() {
            return Unsafe.getUnsafe().getLong(DirectLongLongDescList.this.ptr + 16L * (long)this.pos);
        }
    }
}

