/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLowerCaseUtf8SequenceHashSet;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.util.Arrays;

public class LowerCaseUtf8SequenceObjHashMap<V>
extends AbstractLowerCaseUtf8SequenceHashSet {
    private final ObjList<Utf8String> list;
    private V[] values;

    public LowerCaseUtf8SequenceObjHashMap() {
        this(8);
    }

    public LowerCaseUtf8SequenceObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    private LowerCaseUtf8SequenceObjHashMap(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.list = new ObjList(this.capacity);
        this.values = new Object[this.keys.length];
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        this.list.clear();
    }

    public V get(Utf8Sequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public ObjList<Utf8String> keys() {
        return this.list;
    }

    public boolean put(Utf8String key, V value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean put(Utf8Sequence key, V value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, Utf8Sequence key, V value) {
        assert (value != null);
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        Utf8String onHeapKey = Utf8String.newInstance(key);
        this.keys[index] = onHeapKey;
        this.hashCodes[index] = Utf8s.lowerCaseAsciiHashCode(key);
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
        this.list.add(onHeapKey);
        return true;
    }

    public boolean putAt(int index, Utf8String key, V value) {
        assert (value != null);
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.keys[index] = key;
        this.hashCodes[index] = Utf8s.lowerCaseAsciiHashCode(key);
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
        this.list.add(key);
        return true;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            Utf8Sequence key = this.keys[-index - 1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    public V valueAt(int index) {
        return index < 0 ? (V)this.valueAtQuick(index) : null;
    }

    public V valueAtQuick(int index) {
        return this.values[-index - 1];
    }

    public V valueQuick(int index) {
        return this.get(this.list.getQuick(index));
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        Utf8Sequence[] oldKeys = this.keys;
        int[] oldHashCodes = this.hashCodes;
        V[] oldValues = this.values;
        this.keys = new Utf8Sequence[len];
        this.hashCodes = new int[len];
        this.values = new Object[len];
        Arrays.fill(this.keys, null);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            Utf8Sequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.hashCodes[index] = oldHashCodes[i];
            this.values[index] = oldValues[i];
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.hashCodes[index] = 0;
        this.values[index] = null;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.hashCodes[to] = this.hashCodes[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }
}

