/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.histogram.org.HdrHistogram;

import io.questdb.std.histogram.org.HdrHistogram.DoubleHistogram;
import io.questdb.std.histogram.org.HdrHistogram.DoubleHistogramIterationValue;
import io.questdb.std.histogram.org.HdrHistogram.LogarithmicIterator;
import java.util.Iterator;

public class DoubleLogarithmicIterator
implements Iterator<DoubleHistogramIterationValue> {
    private final LogarithmicIterator integerLogarithmicIterator;
    private final DoubleHistogramIterationValue iterationValue;
    DoubleHistogram histogram;

    public DoubleLogarithmicIterator(DoubleHistogram histogram, double valueUnitsInFirstBucket, double logBase) {
        this.histogram = histogram;
        this.integerLogarithmicIterator = new LogarithmicIterator(histogram.integerValuesHistogram, (long)(valueUnitsInFirstBucket * histogram.getDoubleToIntegerValueConversionRatio()), logBase);
        this.iterationValue = new DoubleHistogramIterationValue(this.integerLogarithmicIterator.currentIterationValue);
    }

    @Override
    public boolean hasNext() {
        return this.integerLogarithmicIterator.hasNext();
    }

    @Override
    public DoubleHistogramIterationValue next() {
        this.integerLogarithmicIterator.next();
        return this.iterationValue;
    }

    @Override
    public void remove() {
        this.integerLogarithmicIterator.remove();
    }

    public void reset(double valueUnitsInFirstBucket, double logBase) {
        this.integerLogarithmicIterator.reset((long)(valueUnitsInFirstBucket * this.histogram.getDoubleToIntegerValueConversionRatio()), logBase);
    }
}

