/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8s;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class GcUtf8String
implements DirectUtf8Sequence {
    private static final long BUFFER_ADDRESS_OFFSET;
    private final ByteBuffer buffer;
    @NotNull
    private final String original;
    private final long ptr;
    private final int size;
    private final long zeroPaddedSixPrefix;

    public GcUtf8String(@NotNull String original) {
        this.original = original;
        byte[] bytes = original.getBytes(StandardCharsets.UTF_8);
        this.buffer = ByteBuffer.allocateDirect(bytes.length);
        this.buffer.put(bytes);
        this.buffer.rewind();
        this.ptr = Unsafe.getUnsafe().getLong(this.buffer, BUFFER_ADDRESS_OFFSET);
        this.size = bytes.length;
        this.zeroPaddedSixPrefix = Utf8s.zeroPaddedSixPrefix(this);
    }

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        return this.original;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcUtf8String that = (GcUtf8String)o;
        return this.original.equals(that.original);
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    @Override
    public boolean isAscii() {
        return this.original.length() == this.size;
    }

    @Override
    public long ptr() {
        return this.ptr;
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return this.original;
    }

    @Override
    public long zeroPaddedSixPrefix() {
        return this.zeroPaddedSixPrefix;
    }

    static {
        Field addressField;
        try {
            addressField = Buffer.class.getDeclaredField("address");
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
        BUFFER_ADDRESS_OFFSET = Unsafe.getUnsafe().objectFieldOffset(addressField);
    }
}

