/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hertzbeat.collector.dispatch.CollectDataDispatch;
import org.apache.hertzbeat.collector.dispatch.MetricsCollect;
import org.apache.hertzbeat.collector.dispatch.MetricsCollectorQueue;
import org.apache.hertzbeat.collector.dispatch.MetricsTaskDispatch;
import org.apache.hertzbeat.collector.dispatch.WorkerPool;
import org.apache.hertzbeat.collector.dispatch.entrance.internal.CollectJobService;
import org.apache.hertzbeat.collector.dispatch.unit.UnitConvert;
import org.apache.hertzbeat.collector.metrics.HertzBeatMetricsCollector;
import org.apache.hertzbeat.collector.timer.TimerDispatch;
import org.apache.hertzbeat.collector.timer.WheelTimerTask;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.timer.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonDispatcher
implements MetricsTaskDispatch,
CollectDataDispatch {
    private static final Logger log = LoggerFactory.getLogger(CommonDispatcher.class);
    private static final long DURATION_TIME = 240000L;
    private static final int MAX_SUB_TASK_NUM = 50;
    private static final int ENV_CONFIG_SIZE = 1;
    private static final Gson GSON = new Gson();
    private final MetricsCollectorQueue jobRequestQueue;
    private final TimerDispatch timerDispatch;
    private final CommonDataQueue commonDataQueue;
    private final Map<String, MetricsTime> metricsTimeoutMonitorMap;
    private final List<UnitConvert> unitConvertList;
    private final WorkerPool workerPool;
    private final String collectorIdentity;
    @Autowired
    private HertzBeatMetricsCollector metricsCollector;

    public CommonDispatcher(MetricsCollectorQueue jobRequestQueue, TimerDispatch timerDispatch, CommonDataQueue commonDataQueue, WorkerPool workerPool, CollectJobService collectJobService, List<UnitConvert> unitConvertList) {
        this.commonDataQueue = commonDataQueue;
        this.jobRequestQueue = jobRequestQueue;
        this.timerDispatch = timerDispatch;
        this.unitConvertList = unitConvertList;
        this.workerPool = workerPool;
        this.collectorIdentity = collectJobService.getCollectorIdentity();
        this.metricsTimeoutMonitorMap = new ConcurrentHashMap<String, MetricsTime>(16);
        this.start();
    }

    public void start() {
        try {
            this.workerPool.executeJob(() -> {
                Thread.currentThread().setName("metrics-task-dispatcher");
                while (!Thread.currentThread().isInterrupted()) {
                    MetricsCollect metricsCollect = null;
                    try {
                        metricsCollect = this.jobRequestQueue.getJob();
                        if (metricsCollect == null) continue;
                        this.workerPool.executeJob((Runnable)metricsCollect);
                    }
                    catch (RejectedExecutionException rejected) {
                        log.warn("[Dispatcher]-the worker pool is full, reject this metrics task\uff0cput in queue again.");
                        if (metricsCollect == null) continue;
                        metricsCollect.setRunPriority((byte)(metricsCollect.getRunPriority() + 1));
                        this.jobRequestQueue.addJob(metricsCollect);
                    }
                    catch (InterruptedException interruptedException) {
                        log.info("[Dispatcher]-metrics-task-dispatcher has been interrupt to close.");
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        log.error("[Dispatcher]-{}.", (Object)e.getMessage(), (Object)e);
                    }
                }
                log.info("Thread Interrupted, Shutdown the [metrics-task-dispatcher]");
            });
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("metrics-task-timeout-monitor-%d").setDaemon(true).build();
            ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1, threadFactory);
            scheduledExecutor.scheduleWithFixedDelay(this::monitorCollectTaskTimeout, 2L, 20L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("Common Dispatcher error: {}.", (Object)e.getMessage(), (Object)e);
        }
    }

    private void monitorCollectTaskTimeout() {
        try {
            long deadline = System.currentTimeMillis() - 240000L;
            for (Map.Entry<String, MetricsTime> entry : this.metricsTimeoutMonitorMap.entrySet()) {
                MetricsTime removedMetricsTime;
                MetricsTime metricsTime = entry.getValue();
                if (metricsTime.getStartTime() >= deadline || (removedMetricsTime = this.metricsTimeoutMonitorMap.remove(entry.getKey())) == null) continue;
                WheelTimerTask timerJob = (WheelTimerTask)metricsTime.getTimeout().task();
                Job job = timerJob.getJob();
                if (this.metricsCollector != null) {
                    long duration = System.currentTimeMillis() - removedMetricsTime.getStartTime();
                    this.metricsCollector.recordCollectMetrics(job, duration, "timeout");
                }
                CollectRep.MetricsData metricsData = CollectRep.MetricsData.newBuilder().setId(job.getMonitorId()).setTenantId(job.getTenantId()).setApp(job.getApp()).setMetrics(metricsTime.getMetrics().getName()).setPriority((int)metricsTime.getMetrics().getPriority().byteValue()).setTime(System.currentTimeMillis()).setCode(CollectRep.Code.TIMEOUT).setMsg("collect timeout").build();
                log.error("[Collect Timeout]: \n{}", (Object)metricsData);
                if (metricsData.getPriority() != 0) continue;
                this.dispatchCollectData(metricsTime.timeout, metricsTime.getMetrics(), metricsData);
            }
        }
        catch (Exception e) {
            log.error("[Task Timeout Monitor]-{}.", (Object)e.getMessage(), (Object)e);
        }
    }

    public void dispatchMetricsTask(Timeout timeout) {
        WheelTimerTask timerTask = (WheelTimerTask)timeout.task();
        Job job = timerTask.getJob();
        job.constructPriorMetrics();
        Set metricsSet = job.getNextCollectMetrics(null, true);
        metricsSet.forEach(metrics -> {
            MetricsCollect metricsCollect = new MetricsCollect((Metrics)metrics, timeout, this, this.collectorIdentity, this.unitConvertList);
            this.jobRequestQueue.addJob(metricsCollect);
            if (metrics.getPrometheus() != null) {
                this.metricsTimeoutMonitorMap.put(String.valueOf(job.getId()), new MetricsTime(System.currentTimeMillis(), (Metrics)metrics, timeout));
            } else {
                this.metricsTimeoutMonitorMap.put(job.getId() + "-" + metrics.getName(), new MetricsTime(System.currentTimeMillis(), (Metrics)metrics, timeout));
            }
        });
    }

    public void dispatchCollectData(Timeout timeout, Metrics metrics, CollectRep.MetricsData metricsData) {
        WheelTimerTask timerJob = (WheelTimerTask)timeout.task();
        Job job = timerJob.getJob();
        String monitorKey = metrics.isHasSubTask() ? job.getId() + "-" + metrics.getName() + "-sub-" + metrics.getSubTaskId() : job.getId() + "-" + metrics.getName();
        MetricsTime metricsTime = this.metricsTimeoutMonitorMap.remove(monitorKey);
        if (metricsTime != null && this.metricsCollector != null) {
            long duration = System.currentTimeMillis() - metricsTime.getStartTime();
            String status = metricsData.getCode() == CollectRep.Code.SUCCESS ? "success" : "fail";
            this.metricsCollector.recordCollectMetrics(job, duration, status);
        }
        if (metrics.isHasSubTask()) {
            boolean isLastTask = metrics.consumeSubTaskResponse(metricsData);
            if (isLastTask) {
                metricsData = ((CollectRep.MetricsData.Builder)metrics.getSubTaskDataRef().get()).build();
            } else {
                return;
            }
        }
        Set metricsSet = job.getNextCollectMetrics(metrics, false);
        if (job.isCyclic()) {
            boolean isAvailableCollectFailed;
            if (log.isDebugEnabled()) {
                log.debug("Cyclic Job: {} - {} - {}", new Object[]{job.getMonitorId(), job.getApp(), metricsData.getMetrics()});
                for (CollectRep.ValueRow valueRow : metricsData.getValues()) {
                    for (CollectRep.Field field : metricsData.getFields()) {
                        log.debug("Field-->{},Value-->{}", (Object)field.getName(), (Object)valueRow.getColumns(metricsData.getFields().indexOf(field)));
                    }
                }
            }
            boolean bl = isAvailableCollectFailed = metricsSet != null && !metricsSet.isEmpty() && metrics.getPriority() == 0 && metricsData.getCode() != CollectRep.Code.SUCCESS;
            if (metricsSet == null || isAvailableCollectFailed || job.isSd()) {
                if (!timeout.isCancelled()) {
                    this.timerDispatch.cyclicJob(timerJob);
                }
            } else if (!metricsSet.isEmpty()) {
                List configmapList = CollectUtil.getConfigmapFromPreCollectData((CollectRep.MetricsData)metricsData);
                if (configmapList.size() == 1) {
                    job.addEnvConfigmaps((Map)configmapList.get(0));
                }
                for (Metrics metricItem2 : metricsSet) {
                    Set cryPlaceholderFields = CollectUtil.matchCryPlaceholderField((JsonElement)GSON.toJsonTree((Object)metricItem2));
                    if (cryPlaceholderFields.isEmpty()) {
                        MetricsCollect metricsCollect = new MetricsCollect(metricItem2, timeout, this, this.collectorIdentity, this.unitConvertList);
                        this.jobRequestQueue.addJob(metricsCollect);
                        this.metricsTimeoutMonitorMap.put(job.getId() + "-" + metricItem2.getName(), new MetricsTime(System.currentTimeMillis(), metricItem2, timeout));
                        continue;
                    }
                    boolean isSubTask = configmapList.stream().anyMatch(map -> map.keySet().stream().anyMatch(cryPlaceholderFields::contains));
                    int subTaskNum = isSubTask ? Math.min(configmapList.size(), 50) : 1;
                    AtomicInteger subTaskNumAtomic = new AtomicInteger(subTaskNum);
                    AtomicReference metricsDataReference = new AtomicReference();
                    for (int index = 0; index < subTaskNum; ++index) {
                        HashMap configmap = new HashMap(job.getEnvConfigmaps());
                        if (isSubTask) {
                            Map preConfigMap = (Map)configmapList.get(index);
                            configmap.putAll(preConfigMap);
                        }
                        Metrics metric = CollectUtil.replaceCryPlaceholderToMetrics((Metrics)metricItem2, configmap);
                        metric.setSubTaskNum(subTaskNumAtomic);
                        metric.setSubTaskId(Integer.valueOf(index));
                        metric.setSubTaskDataRef(metricsDataReference);
                        MetricsCollect metricsCollect = new MetricsCollect(metric, timeout, this, this.collectorIdentity, this.unitConvertList);
                        this.jobRequestQueue.addJob(metricsCollect);
                        this.metricsTimeoutMonitorMap.put(job.getId() + "-" + metric.getName() + "-sub-" + index, new MetricsTime(System.currentTimeMillis(), metric, timeout));
                    }
                }
            }
            if (job.isSd()) {
                CollectRep.MetricsData sdMetricsData = CollectRep.MetricsData.newBuilder((CollectRep.MetricsData)metricsData).build();
                this.commonDataQueue.sendServiceDiscoveryData(sdMetricsData);
            }
            this.commonDataQueue.sendMetricsData(metricsData);
        } else {
            job.addCollectMetricsData(metricsData);
            if (log.isDebugEnabled()) {
                log.debug("One-time Job: {}", (Object)metricsData.getMetrics());
                for (CollectRep.ValueRow valueRow : metricsData.getValues()) {
                    for (CollectRep.Field field : metricsData.getFields()) {
                        log.debug("Field-->{},Value-->{}", (Object)field.getName(), (Object)valueRow.getColumns(metricsData.getFields().indexOf(field)));
                    }
                }
            }
            if (job.isSd() || metricsSet == null) {
                this.timerDispatch.responseSyncJobData(job.getId(), job.getResponseDataTemp());
            } else if (!metricsSet.isEmpty()) {
                metricsSet.forEach(metricItem -> {
                    MetricsCollect metricsCollect = new MetricsCollect((Metrics)metricItem, timeout, this, this.collectorIdentity, this.unitConvertList);
                    this.jobRequestQueue.addJob(metricsCollect);
                    this.metricsTimeoutMonitorMap.put(job.getId() + "-" + metricItem.getName(), new MetricsTime(System.currentTimeMillis(), (Metrics)metricItem, timeout));
                });
            }
        }
    }

    public void dispatchCollectData(Timeout timeout, Metrics metrics, List<CollectRep.MetricsData> metricsDataList) {
        WheelTimerTask timerJob = (WheelTimerTask)timeout.task();
        Job job = timerJob.getJob();
        MetricsTime metricsTime = this.metricsTimeoutMonitorMap.remove(String.valueOf(job.getId()));
        if (metricsTime != null && this.metricsCollector != null) {
            long duration = System.currentTimeMillis() - metricsTime.getStartTime();
            boolean isSuccess = metricsDataList.stream().anyMatch(item -> item.getCode() == CollectRep.Code.SUCCESS);
            this.metricsCollector.recordCollectMetrics(job, duration, isSuccess ? "success" : "fail");
        }
        if (job.isCyclic()) {
            if (!timeout.isCancelled()) {
                this.timerDispatch.cyclicJob(timerJob);
            }
            metricsDataList.forEach(arg_0 -> ((CommonDataQueue)this.commonDataQueue).sendMetricsData(arg_0));
        } else {
            this.timerDispatch.responseSyncJobData(job.getId(), metricsDataList);
        }
    }

    protected static class MetricsTime {
        private long startTime;
        private Metrics metrics;
        private Timeout timeout;

        public long getStartTime() {
            return this.startTime;
        }

        public Metrics getMetrics() {
            return this.metrics;
        }

        public Timeout getTimeout() {
            return this.timeout;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setMetrics(Metrics metrics) {
            this.metrics = metrics;
        }

        public void setTimeout(Timeout timeout) {
            this.timeout = timeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetricsTime)) {
                return false;
            }
            MetricsTime other = (MetricsTime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            Metrics this$metrics = this.getMetrics();
            Metrics other$metrics = other.getMetrics();
            if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
                return false;
            }
            Timeout this$timeout = this.getTimeout();
            Timeout other$timeout = other.getTimeout();
            return !(this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetricsTime;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            Metrics $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
            Timeout $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
            return result;
        }

        public String toString() {
            return "CommonDispatcher.MetricsTime(startTime=" + this.getStartTime() + ", metrics=" + this.getMetrics() + ", timeout=" + this.getTimeout() + ")";
        }

        public MetricsTime(long startTime, Metrics metrics, Timeout timeout) {
            this.startTime = startTime;
            this.metrics = metrics;
            this.timeout = timeout;
        }
    }
}

