/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayPositionsFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class HSQLArrayPositionsFunction
extends AbstractArrayPositionsFunction {
    public HSQLArrayPositionsFunction(boolean list, TypeConfiguration typeConfiguration) {
        super(list, typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression elementExpression = (Expression)sqlAstArguments.get(1);
        sqlAppender.append("case when ");
        arrayExpression.accept(walker);
        sqlAppender.append(" is not null then coalesce((select array_agg(t.idx) from unnest(");
        arrayExpression.accept(walker);
        sqlAppender.append(") with ordinality t(val,idx) where t.val is not distinct from ");
        elementExpression.accept(walker);
        sqlAppender.append("),cast(array[] as integer array)) end");
    }
}

