/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.validator.impl;

import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.manager.component.validator.ParamValidator;
import org.springframework.stereotype.Component;

@Component
public class BooleanParamValidator
implements ParamValidator {
    @Override
    public boolean support(String type) {
        return "boolean".equals(type);
    }

    @Override
    public void validate(ParamDefine paramDefine, Param param) {
        String booleanValue = param.getParamValue();
        if (!"true".equalsIgnoreCase(booleanValue) && !"false".equalsIgnoreCase(booleanValue)) {
            throw new IllegalArgumentException("Params field " + paramDefine.getField() + " value " + booleanValue + " is invalid boolean value.");
        }
    }
}

