/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.BuildInformation;
import io.questdb.ConfigPropertyKey;
import io.questdb.ConfigReloader;
import io.questdb.DefaultFactoryProvider;
import io.questdb.FactoryProvider;
import io.questdb.FactoryProviderFactory;
import io.questdb.FreeOnExit;
import io.questdb.MemoryConfiguration;
import io.questdb.MemoryConfigurationWrapper;
import io.questdb.Metrics;
import io.questdb.PropServerConfiguration;
import io.questdb.PropertyKey;
import io.questdb.PublicPassthroughConfiguration;
import io.questdb.ServerConfiguration;
import io.questdb.ServerConfigurationException;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoConfigurationWrapper;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.HttpFullFatServerConfiguration;
import io.questdb.cutlass.http.HttpMinServerConfigurationWrapper;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.HttpServerConfigurationWrapper;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfigurationWrapper;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.cutlass.pgwire.PGConfigurationWrapper;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.metrics.MetricsConfiguration;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.str.Path;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DynamicPropServerConfiguration
implements ServerConfiguration,
ConfigReloader {
    private static final Log LOG = LogFactory.getLog(DynamicPropServerConfiguration.class);
    private static final Set<? extends ConfigPropertyKey> dynamicProps = new HashSet<PropertyKey>(Arrays.asList(PropertyKey.PG_USER, PropertyKey.PG_PASSWORD, PropertyKey.PG_RO_USER_ENABLED, PropertyKey.PG_RO_USER, PropertyKey.PG_RO_PASSWORD, PropertyKey.PG_NAMED_STATEMENT_LIMIT, PropertyKey.PG_RECV_BUFFER_SIZE, PropertyKey.PG_SEND_BUFFER_SIZE, PropertyKey.PG_NET_CONNECTION_LIMIT, PropertyKey.HTTP_REQUEST_HEADER_BUFFER_SIZE, PropertyKey.HTTP_MULTIPART_HEADER_BUFFER_SIZE, PropertyKey.HTTP_RECV_BUFFER_SIZE, PropertyKey.HTTP_SEND_BUFFER_SIZE, PropertyKey.HTTP_NET_CONNECTION_LIMIT, PropertyKey.LINE_HTTP_MAX_RECV_BUFFER_SIZE, PropertyKey.LINE_TCP_NET_CONNECTION_LIMIT, PropertyKey.QUERY_TRACING_ENABLED, PropertyKey.CAIRO_MAT_VIEW_INSERT_AS_SELECT_BATCH_SIZE, PropertyKey.CAIRO_MAT_VIEW_ROWS_PER_QUERY_ESTIMATE, PropertyKey.CAIRO_MAT_VIEW_MAX_REFRESH_RETRIES, PropertyKey.CAIRO_MAT_VIEW_MAX_REFRESH_INTERVALS, PropertyKey.CAIRO_SQL_ASOF_JOIN_EVACUATION_THRESHOLD, PropertyKey.CAIRO_SQL_ASOF_JOIN_SHORT_CIRCUIT_CACHE_CAPACITY));
    private static final Function<String, ? extends ConfigPropertyKey> keyResolver = k -> {
        Optional<PropertyKey> prop = PropertyKey.getByString(k);
        return prop.orElse(null);
    };
    private final BuildInformation buildInformation;
    private final CairoConfigurationWrapper cairoConfig;
    private final java.nio.file.Path confPath;
    private final boolean configReloadEnabled;
    @Nullable
    private final Map<String, String> env;
    private final FilesFacade filesFacade;
    private final FactoryProviderFactory fpf;
    private final HttpServerConfigurationWrapper httpServerConfig;
    private final String installRoot;
    private final LineTcpReceiverConfigurationWrapper lineTcpConfig;
    private final boolean loadAdditionalConfigurations;
    private final Log log;
    private final MemoryConfigurationWrapper memoryConfig;
    private final Metrics metrics;
    private final MicrosecondClock microsecondClock;
    private final HttpMinServerConfigurationWrapper minHttpServerConfig;
    private final PGConfigurationWrapper pgWireConfig;
    private final Properties properties;
    private final Object reloadLock = new Object();
    private final AtomicReference<PropServerConfiguration> serverConfig;
    private long version;

    public DynamicPropServerConfiguration(String installRoot, Properties properties, @Nullable Map<String, String> env, Log log, BuildInformation buildInformation, FilesFacade filesFacade, MicrosecondClock microsecondClock, FactoryProviderFactory fpf, boolean loadAdditionalConfigurations) throws ServerConfigurationException, JsonException {
        this.installRoot = installRoot;
        this.properties = properties;
        this.env = env;
        this.log = log;
        this.buildInformation = buildInformation;
        this.filesFacade = filesFacade;
        this.microsecondClock = microsecondClock;
        this.fpf = fpf;
        this.loadAdditionalConfigurations = loadAdditionalConfigurations;
        PropServerConfiguration serverConfig = new PropServerConfiguration(installRoot, properties, dynamicProps, env, log, buildInformation, filesFacade, microsecondClock, fpf, loadAdditionalConfigurations);
        this.metrics = serverConfig.getMetrics();
        this.serverConfig = new AtomicReference<PropServerConfiguration>(serverConfig);
        this.cairoConfig = new CairoConfigurationWrapper(this.metrics);
        this.minHttpServerConfig = new HttpMinServerConfigurationWrapper(this.metrics);
        this.httpServerConfig = new HttpServerConfigurationWrapper(this.metrics);
        this.lineTcpConfig = new LineTcpReceiverConfigurationWrapper(this.metrics);
        this.memoryConfig = new MemoryConfigurationWrapper();
        this.pgWireConfig = new PGConfigurationWrapper(this.metrics);
        this.reloadNestedConfigurations(serverConfig);
        this.version = 0L;
        this.confPath = Paths.get(this.getCairoConfiguration().getConfRoot().toString(), "/server.conf");
        this.configReloadEnabled = serverConfig.isConfigReloadEnabled();
    }

    public DynamicPropServerConfiguration(String installRoot, Properties properties, @Nullable Map<String, String> env, Log log, BuildInformation buildInformation, FilesFacade filesFacade, MicrosecondClock microsecondClock, FactoryProviderFactory fpf) throws ServerConfigurationException, JsonException {
        this(installRoot, properties, env, log, buildInformation, filesFacade, microsecondClock, fpf, true);
    }

    public DynamicPropServerConfiguration(String installRoot, Properties properties, @Nullable Map<String, String> env, Log log, BuildInformation buildInformation) throws ServerConfigurationException, JsonException {
        this(installRoot, properties, env, log, buildInformation, FilesFacadeImpl.INSTANCE, MicrosecondClockImpl.INSTANCE, (configuration, engine, freeOnExitList) -> DefaultFactoryProvider.INSTANCE, true);
    }

    public static boolean updateSupportedProperties(Properties oldProperties, Properties newProperties, Set<? extends ConfigPropertyKey> reloadableProps, Function<String, ? extends ConfigPropertyKey> keyResolver, Log log) {
        if (newProperties.equals(oldProperties)) {
            return false;
        }
        boolean changed = false;
        for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
            String key = (String)entry.getKey();
            String oldVal = oldProperties.getProperty(key);
            if (oldVal != null && oldVal.equals(entry.getValue())) continue;
            ConfigPropertyKey propKey = keyResolver.apply(key);
            if (propKey == null) {
                log.error().$("unknown property, ignoring [update, key=").$(key).I$();
                continue;
            }
            if (reloadableProps.contains(propKey)) {
                LogRecord rec = log.info().$("reloaded config option [update, key=").$(key);
                if (!propKey.isSensitive()) {
                    rec.$(", oldValue=").$(oldVal).$(", newValue=").$((String)entry.getValue());
                }
                rec.I$();
                oldProperties.setProperty(key, (String)entry.getValue());
                changed = true;
                continue;
            }
            log.advisory().$("property ").$(key).$(" was modified in the config file but cannot be reloaded. Ignoring new value").$();
        }
        Iterator<Object> oldPropsIter = oldProperties.keySet().iterator();
        while (oldPropsIter.hasNext()) {
            Object key = oldPropsIter.next();
            if (newProperties.containsKey(key)) continue;
            ConfigPropertyKey propKey = keyResolver.apply((String)key);
            if (propKey == null) {
                log.error().$("unknown property, ignoring [remove, key=").$(key).I$();
                continue;
            }
            if (reloadableProps.contains(propKey)) {
                LogRecord rec = log.info().$("reloaded config option [remove, key=").$(key);
                if (!propKey.isSensitive()) {
                    rec.$(", value=").$(oldProperties.getProperty((String)key));
                }
                rec.I$();
                oldPropsIter.remove();
                changed = true;
                continue;
            }
            log.advisory().$("property ").$(key).$(" was removed from the config file but cannot be reloaded. Ignoring").$();
        }
        return changed;
    }

    @Override
    public CairoConfiguration getCairoConfiguration() {
        return this.cairoConfig;
    }

    @Override
    public FactoryProvider getFactoryProvider() {
        return this.serverConfig.get().getFactoryProvider();
    }

    @Override
    public HttpServerConfiguration getHttpMinServerConfiguration() {
        return this.minHttpServerConfig;
    }

    @Override
    public HttpFullFatServerConfiguration getHttpServerConfiguration() {
        return this.httpServerConfig;
    }

    @Override
    public LineTcpReceiverConfiguration getLineTcpReceiverConfiguration() {
        return this.lineTcpConfig;
    }

    @Override
    public LineUdpReceiverConfiguration getLineUdpReceiverConfiguration() {
        return this.serverConfig.get().getLineUdpReceiverConfiguration();
    }

    @Override
    public WorkerPoolConfiguration getMatViewRefreshPoolConfiguration() {
        return this.serverConfig.get().getMatViewRefreshPoolConfiguration();
    }

    @Override
    public MemoryConfiguration getMemoryConfiguration() {
        return this.memoryConfig;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public MetricsConfiguration getMetricsConfiguration() {
        return this.serverConfig.get().getMetricsConfiguration();
    }

    @Override
    public PGConfiguration getPGWireConfiguration() {
        return this.pgWireConfig;
    }

    @Override
    public PublicPassthroughConfiguration getPublicPassthroughConfiguration() {
        return this.serverConfig.get().getPublicPassthroughConfiguration();
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public WorkerPoolConfiguration getWalApplyPoolConfiguration() {
        return this.serverConfig.get().getWalApplyPoolConfiguration();
    }

    @Override
    public WorkerPoolConfiguration getNetworkWorkerPoolConfiguration() {
        return this.serverConfig.get().getNetworkWorkerPoolConfiguration();
    }

    @Override
    public WorkerPoolConfiguration getQueryWorkerPoolConfiguration() {
        return this.serverConfig.get().getQueryWorkerPoolConfiguration();
    }

    @Override
    public WorkerPoolConfiguration getWriteWorkerPoolConfiguration() {
        return this.serverConfig.get().getWriteWorkerPoolConfiguration();
    }

    @Override
    public void init(CairoEngine engine, FreeOnExit freeOnExit) {
        this.serverConfig.get().init(this, engine, freeOnExit);
        if (this.configReloadEnabled) {
            engine.setConfigReloader(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reload() {
        Path p = new Path();
        try {
            p.of(this.confPath.toString());
            Object object = this.reloadLock;
            synchronized (object) {
                Properties newProperties = new Properties();
                try (InputStream is = Files.newInputStream(this.confPath, new OpenOption[0]);){
                    newProperties.load(is);
                }
                catch (IOException exc) {
                    LOG.error().$(exc).$();
                    boolean bl = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 9, 12] lbl21 : MonitorExitStatement: MONITOREXIT : var2_2
                    p.close();
                    return bl;
                }
                if (DynamicPropServerConfiguration.updateSupportedProperties(this.properties, newProperties, dynamicProps, keyResolver, LOG)) {
                    this.reload0();
                    LOG.info().$("reloaded, [file=").$(this.confPath).I$();
                    boolean bl = true;
                    return bl;
                }
                LOG.info().$("nothing to reload [file=").$(this.confPath).I$();
            }
        }
        finally {
            try {
                p.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
        return false;
    }

    private void reload0() {
        PropServerConfiguration newConfig;
        try {
            newConfig = new PropServerConfiguration(this.installRoot, this.properties, dynamicProps, this.env, this.log, this.buildInformation, this.filesFacade, this.microsecondClock, this.fpf, this.loadAdditionalConfigurations);
        }
        catch (ServerConfigurationException | JsonException e) {
            this.log.error().$(e).$();
            return;
        }
        PropServerConfiguration oldConfig = this.serverConfig.get();
        newConfig.reinit(oldConfig.getFactoryProvider());
        this.serverConfig.set(newConfig);
        this.reloadNestedConfigurations(newConfig);
        ++this.version;
    }

    private void reloadNestedConfigurations(PropServerConfiguration serverConfig) {
        this.cairoConfig.setDelegate(serverConfig.getCairoConfiguration());
        this.minHttpServerConfig.setDelegate(serverConfig.getHttpMinServerConfiguration());
        this.httpServerConfig.setDelegate(serverConfig.getHttpServerConfiguration());
        this.lineTcpConfig.setDelegate(serverConfig.getLineTcpReceiverConfiguration());
        this.memoryConfig.setDelegate(serverConfig.getMemoryConfiguration());
        this.pgWireConfig.setDelegate(serverConfig.getPGWireConfiguration());
    }
}

