/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.std.str.Path;

public class BitmapIndexBwdNullReader
implements BitmapIndexReader {
    private final NullCursor cursor = new NullCursor();
    private long columnTxn;
    private long partitionTxn;

    public BitmapIndexBwdNullReader(long columnTxn, long partitionTxn) {
        this.columnTxn = columnTxn;
        this.partitionTxn = partitionTxn;
    }

    @Override
    public long getColumnTop() {
        return 0L;
    }

    @Override
    public long getColumnTxn() {
        return this.columnTxn;
    }

    @Override
    public RowCursor getCursor(boolean cachedInstance, int key, long minValue, long maxValue) {
        NullCursor cursor = this.getCursor(cachedInstance);
        cursor.value = key == 0 ? maxValue - minValue : -1L;
        return cursor;
    }

    @Override
    public long getKeyBaseAddress() {
        return 0L;
    }

    @Override
    public int getKeyCount() {
        return 1;
    }

    @Override
    public long getKeyMemorySize() {
        return 0L;
    }

    @Override
    public long getPartitionTxn() {
        return this.partitionTxn;
    }

    @Override
    public long getValueBaseAddress() {
        return 0L;
    }

    @Override
    public int getValueBlockCapacity() {
        return 0;
    }

    @Override
    public long getValueMemorySize() {
        return 0L;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void of(CairoConfiguration configuration, Path path, CharSequence columnName, long columnNameTxn, long partitionTxn, long columnTop) {
        this.columnTxn = columnNameTxn;
        this.partitionTxn = partitionTxn;
    }

    @Override
    public void reloadConditionally() {
    }

    private NullCursor getCursor(boolean cachedInstance) {
        return cachedInstance ? this.cursor : new NullCursor();
    }

    private static class NullCursor
    implements RowCursor {
        private long value;

        private NullCursor() {
        }

        @Override
        public boolean hasNext() {
            return this.value > -1L;
        }

        @Override
        public long next() {
            return this.value--;
        }
    }
}

