/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableUtils;
import io.questdb.std.Misc;
import io.questdb.std.PagedDirectLongList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.io.Closeable;

public class DedupColumnCommitAddresses
implements Closeable {
    public static final long NULL = 0L;
    private static final long COL_TYPE_32 = 0L;
    private static final long VAL_SIZE_32 = 4L;
    private static final long COL_TOP_64 = 8L;
    private static final long COL_DATA_64 = 16L;
    private static final long COL_VAR_DATA_64 = 24L;
    private static final long COL_VAR_DATA_LEN_64 = 32L;
    private static final long O3_DATA_64 = 40L;
    private static final long O3_VAR_DATA_64 = 48L;
    private static final long O3_VAR_DATA_LEN_64 = 56L;
    private static final long RESERVED1 = 64L;
    private static final long RESERVED2 = 72L;
    private static final long RESERVED3 = 80L;
    private static final long RESERVED4 = 88L;
    private static final long RESERVED5 = 96L;
    private static final long NULL_VAL_256 = 104L;
    private static final int RECORD_BYTES = 136;
    private PagedDirectLongList addresses;
    private int columnCount;

    public static long getAddress(long dedupCommitAddr) {
        return dedupCommitAddr;
    }

    public static long getColReserved1(long dedupBlockAddress, int keyIndex) {
        return Unsafe.getUnsafe().getLong(dedupBlockAddress + (long)keyIndex * 136L + 64L);
    }

    public static long getColReserved2(long dedupBlockAddress, int keyIndex) {
        return Unsafe.getUnsafe().getLong(dedupBlockAddress + (long)keyIndex * 136L + 72L);
    }

    public static long getColReserved3(long dedupBlockAddress, int keyIndex) {
        return Unsafe.getUnsafe().getLong(dedupBlockAddress + (long)keyIndex * 136L + 80L);
    }

    public static long getColReserved4(long dedupBlockAddress, int keyIndex) {
        return Unsafe.getUnsafe().getLong(dedupBlockAddress + (long)keyIndex * 136L + 88L);
    }

    public static long getColReserved5(long dedupBlockAddress, int keyIndex) {
        return Unsafe.getUnsafe().getLong(dedupBlockAddress + (long)keyIndex * 136L + 96L);
    }

    public static long getColVarDataLen(long dedupBlockAddress, int keyIndex) {
        return Unsafe.getUnsafe().getLong(dedupBlockAddress + (long)keyIndex * 136L + 32L);
    }

    public static long getO3VarDataLen(long dedupBlockAddress, int keyIndex) {
        return Unsafe.getUnsafe().getLong(dedupBlockAddress + (long)keyIndex * 136L + 56L);
    }

    public static void setColAddressValues(long addr, long columnDataAddress) {
        Unsafe.getUnsafe().putLong(addr + 16L, columnDataAddress);
        Unsafe.getUnsafe().putLong(addr + 24L, 0L);
        Unsafe.getUnsafe().putLong(addr + 32L, 0L);
    }

    public static void setColAddressValues(long addr, long columnDataAddress, long columnVarDataAddress, long columnVarDataLen) {
        Unsafe.getUnsafe().putLong(addr + 16L, columnDataAddress);
        Unsafe.getUnsafe().putLong(addr + 24L, columnVarDataAddress);
        Unsafe.getUnsafe().putLong(addr + 32L, columnVarDataLen);
    }

    public static long setColValues(long dedupCommitAddr, int dedupKeyIndex, int columnType, int valueSizeBytes, long columnTop) {
        long addr = dedupCommitAddr + (long)dedupKeyIndex * 136L;
        Unsafe.getUnsafe().putInt(addr + 0L, columnType);
        Unsafe.getUnsafe().putInt(addr + 4L, valueSizeBytes);
        Unsafe.getUnsafe().putLong(addr + 8L, columnTop);
        Unsafe.getUnsafe().putLong(addr + 104L, TableUtils.getNullLong(columnType, 0));
        Unsafe.getUnsafe().putLong(addr + 104L + 8L, TableUtils.getNullLong(columnType, 1));
        Unsafe.getUnsafe().putLong(addr + 104L + 16L, TableUtils.getNullLong(columnType, 2));
        Unsafe.getUnsafe().putLong(addr + 104L + 24L, TableUtils.getNullLong(columnType, 3));
        return addr;
    }

    public static void setO3DataAddressValues(long addr, long o3DataAddress) {
        Unsafe.getUnsafe().putLong(addr + 40L, o3DataAddress);
        Unsafe.getUnsafe().putLong(addr + 48L, 0L);
        Unsafe.getUnsafe().putLong(addr + 56L, 0L);
    }

    public static void setO3DataAddressValues(long addr, long o3DataAddress, long o3VarDataAddress, long o3VarDataLen) {
        Unsafe.getUnsafe().putLong(addr + 40L, o3DataAddress);
        Unsafe.getUnsafe().putLong(addr + 48L, o3VarDataAddress);
        Unsafe.getUnsafe().putLong(addr + 56L, o3VarDataLen);
    }

    public static void setReservedValuesSet1(long addr, long reserved1, long reserved2, long reserved3) {
        Unsafe.getUnsafe().putLong(addr + 64L, reserved1);
        Unsafe.getUnsafe().putLong(addr + 72L, reserved2);
        Unsafe.getUnsafe().putLong(addr + 80L, reserved3);
    }

    public static void setReservedValuesSet2(long addr, long reserved4, long reserved5) {
        Unsafe.getUnsafe().putLong(addr + 88L, reserved4);
        Unsafe.getUnsafe().putLong(addr + 96L, reserved5);
    }

    public long allocateBlock() {
        if (this.columnCount == 0) {
            return -1L;
        }
        return this.addresses.allocateBlock();
    }

    public void clear(long dedupColSinkAddr) {
        Vect.memset(dedupColSinkAddr, (long)this.columnCount * 136L, 0);
    }

    public void clear() {
        if (this.addresses != null) {
            this.addresses.clear();
        }
    }

    @Override
    public void close() {
        this.addresses = Misc.free(this.addresses);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setDedupColumnCount(int dedupColumnCount) {
        if (dedupColumnCount > 0) {
            if (this.addresses == null) {
                this.addresses = new PagedDirectLongList(45);
            } else {
                this.addresses.clear();
            }
            int longsPerBlock = 17;
            this.addresses.setBlockSize(dedupColumnCount * longsPerBlock);
        } else if (dedupColumnCount == 0) {
            this.clear();
        }
        this.columnCount = dedupColumnCount;
    }
}

