/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cutlass.http.HttpServer;
import io.questdb.cutlass.pgwire.PGServer;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Job;
import org.jetbrains.annotations.Nullable;

public class FlushQueryCacheJob
extends AbstractQueueConsumerJob<Object> {
    private static final Log LOG = LogFactory.getLog(FlushQueryCacheJob.class);
    private final HttpServer httpServer;
    private final PGServer pgServer;

    public FlushQueryCacheJob(MessageBus messageBus, @Nullable HttpServer httpServer, PGServer pgServer) {
        super(null, messageBus.getQueryCacheEventSubSeq());
        this.httpServer = httpServer;
        this.pgServer = pgServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        try {
            if (this.httpServer != null) {
                LOG.info().$("flushing HTTP server select cache").$();
                this.httpServer.clearSelectCache();
            }
            if (this.pgServer != null) {
                LOG.info().$("flushing PGWire server select cache").$();
                this.pgServer.clearSelectCache();
            }
        }
        finally {
            this.subSeq.done(cursor);
        }
        return false;
    }
}

