/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Vect;

public class O3Utils {
    private static final Log LOG = LogFactory.getLog(O3Utils.class);

    public static void copyFixedSizeCol(FilesFacade ff, long srcAddr, long srcLo, long dstAddr, long dstFixFileOffset, long dstFd, boolean mixedIOFlag, long len, int shl) {
        long fromAddress = srcAddr + (srcLo << shl);
        O3Utils.o3Copy(ff, dstAddr, dstFixFileOffset, dstFd, fromAddress, len, mixedIOFlag);
    }

    public static void o3Copy(FilesFacade ff, long dstAddr, long dstFileOffset, long dstFd, long fromAddress, long len, boolean mixedIOFlag) {
        if (mixedIOFlag) {
            if (ff.write(Math.abs(dstFd), fromAddress, len, dstFileOffset) != len) {
                throw CairoException.critical(ff.errno()).put("cannot copy fixed column prefix [fd=").put(dstFd).put(", len=").put(len).put(", offset=").put(fromAddress).put(']');
            }
        } else {
            Vect.memcpy(dstAddr, fromAddress, len);
        }
    }

    static void close(FilesFacade ff, long fd) {
        if (fd > 0L) {
            LOG.debug().$("closed [fd=").$(fd).$(']').$();
            ff.close(fd);
        }
    }

    static void copyFromTimestampIndex(long src, long srcLo, long srcHi, long dstAddr) {
        Vect.copyFromTimestampIndex(src, srcLo, srcHi, dstAddr);
    }

    static void unmap(FilesFacade ff, long addr, long size) {
        if (addr != 0L && size > 0L) {
            ff.munmap(addr, size, 6);
        }
    }

    static void unmapAndClose(FilesFacade ff, long dstFixFd, long dstFixAddr, long dstFixSize) {
        O3Utils.unmap(ff, dstFixAddr, dstFixSize);
        O3Utils.close(ff, dstFixFd);
    }
}

